% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_temkinNLM.R
\name{cv_temkinNLM}
\alias{cv_temkinNLM}
\title{Cross-Validation for Temkin Isotherm Non-Linear Model with Clustering-based Fold Assignment}
\arguments{
\item{Ce}{Numeric vector of equilibrium concentrations (Ce). Must be positive.}

\item{Qe}{Numeric vector of amounts adsorbed (Qe). Must be positive and same length as Ce.}

\item{Temp}{Numeric scalar. Temperature in Kelvin. Must be positive.}

\item{K}{Integer. Number of folds to use in K-fold CV (default is 10). Ignored if loocv = TRUE.}

\item{seed}{Integer. Random seed for reproducibility (default is 123).}

\item{loocv}{Logical. If TRUE, performs leave-one-out cross-validation (overrides K).}

\item{plot}{Logical. If TRUE, displays a barplot of fold MSEs (default is FALSE).}

\item{use_clustering}{Logical. If TRUE, assigns folds using k-means clustering on the data (default FALSE).}
}
\value{
A list with the following components:
\describe{
  \item{mean_mse}{The average mean squared error across all folds.}
  \item{fold_mse}{A numeric vector of MSEs for each fold.}
}
}
\description{
Performs K-fold or leave-one-out cross-validation (LOOCV) on the non-linear Temkin isotherm model:
Qe = (RT / bT) * log(AT * Ce)
Fits a non-linear model of Qe versus Ce using non-linear least squares (nls2).
Evaluates predictive performance using Mean Squared Error (MSE). Optionally displays a barplot of fold-wise MSEs.
Optionally uses clustering-based fold assignment to preserve data structure.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
cv_temkinNLM(Ce, Qe, Temp = 298, K = 5, seed = 123, plot = TRUE, use_clustering = TRUE)
cv_temkinNLM(Ce, Qe, Temp = 298, loocv = TRUE, plot = TRUE)

}
\references{
Montgomery, D.C., Peck, E.A., & Vining, G.G. (2012).
Introduction to Linear Regression Analysis, 5th ed. Wiley.
}
\author{
Paul Angelo C. Manlapaz
}
