% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_merged_vaccine.R
\name{derive_vars_merged_vaccine}
\alias{derive_vars_merged_vaccine}
\title{Add New Variable(s) to the Input dataset Based on Variables from Another dataset}
\usage{
derive_vars_merged_vaccine(
  dataset,
  dataset_ex,
  by_vars_sys,
  by_vars_adms,
  ex_vars
)
}
\arguments{
\item{dataset}{Input dataset which should have been combined with the supplementary(if exists).

The variables specified by the \code{by_vars} argument inside the
\code{derive_vars_merged}are expected.}

\item{dataset_ex}{\code{ex} dataset(combined with \code{suppex}) to merge with the input dataset.

The variables specified by the \code{ex_vars} argument are expected.}

\item{by_vars_sys}{Grouping variables for systemic events.}

\item{by_vars_adms}{Grouping variables for administration site events.}

\item{ex_vars}{Variables to be added to the output dataset from EX dataset}
}
\value{
The dataset with variables added from the EX dataset.
}
\description{
Add new variables to the input dataset based on variables from another dataset.
The variables to be added to the output dataset will be based on input variables
passed on \code{ex_vars} argument.
}
\details{
The input dataset will be merged with \code{EX} dataset for "ADMINISTRATION SITE" and
"SYSTEMIC" categories separately and these datasets will be bound together as
the final output dataset.

This function is intended to add only \code{EX} variables to the input dataset and user
is expected to handle if any pre-processing is required.

Only the variables passed to the \code{ex_vars} will be added in the output dataset

If the input dataset has multiple vaccination for a subject at same visit
then this function will not merge ex dataset and will return the \code{dataset}.
}
\examples{

library(tibble)
library(admiral)
library(dplyr)
library(pharmaversesdtm)

derive_vars_merged_vaccine(
  dataset = face_vaccine,
  dataset_ex = ex_vaccine,
  by_vars_sys = exprs(USUBJID, FATPTREF = EXLNKGRP),
  by_vars_adms = exprs(USUBJID, FATPTREF = EXLNKGRP, FALOC = EXLOC, FALAT = EXLAT),
  ex_vars = exprs(EXTRT, EXDOSE, EXDOSU, EXSTDTC, EXENDTC)
) \%>\%
  select(USUBJID, FATPTREF, FALOC, FALAT, EXTRT, EXDOSE, EXDOSU, EXSTDTC, EXENDTC) \%>\%
  head(10)

derive_vars_merged_vaccine(
  dataset = face_vaccine,
  dataset_ex = ex_vaccine,
  by_vars_sys = exprs(USUBJID, FATPTREF = EXLNKGRP),
  by_vars_adms = exprs(USUBJID, FATPTREF = EXLNKGRP, FALOC = EXLOC, FALAT = EXLAT),
  ex_vars = exprs(EXTRT, EXDOSE, EXDOSU, EXSTDTC, EXENDTC)
)

}
\seealso{
Other der_var: 
\code{\link{derive_var_aval_adis}()},
\code{\link{derive_vars_crit}()},
\code{\link{derive_vars_event_flag}()},
\code{\link{derive_vars_max_flag}()},
\code{\link{derive_vars_params}()},
\code{\link{derive_vars_vaxdt}()}
}
\author{
Vikram S
}
\concept{der_var}
\keyword{der_var}
