# arg_name ----
## Test 1: deprecation error if function is called ----
test_that("arg_name Test 1: deprecation error if function is called", {
  expect_error(
    arg_name(sym("a")),
    class = "lifecycle_error_deprecated"
  )
})

# convert_dtm_to_dtc ----
## Test 2: works if dtm is in correct format ----
test_that("convert_dtm_to_dtc Test 2: works if dtm is in correct format", {
  expect_equal(
    convert_dtm_to_dtc(as.POSIXct("2022-04-05 15:34:07 UTC")),
    "2022-04-05T15:34:07"
  )
})

## Test 3: Error is thrown if dtm is not in correct format ----
test_that("convert_dtm_to_dtc Test 3: Error is thrown if dtm is not in correct format", {
  expect_snapshot(
    convert_dtm_to_dtc("2022-04-05T15:26:14"),
    error = TRUE
  )
})

# filter_if ----
## Test 4: Input is returned as is if filter is NULL ----
test_that("filter_if Test 4: Input is returned as is if filter is NULL", {
  input <- dplyr::tribble(
    ~USUBJID, ~VSTESTCD, ~VSSTRESN,
    "P01",    "WEIGHT",       80.9,
    "P01",    "HEIGHT",      189.2
  )

  expected_output <- input

  expect_dfs_equal(
    expected_output,
    filter_if(input, expr(NULL)),
    keys = c("USUBJID", "VSTESTCD")
  )
})

## Test 5: Input is filtered if filter is not NULL ----
test_that("filter_if Test 5: Input is filtered if filter is not NULL", {
  input <- dplyr::tribble(
    ~USUBJID, ~VSTESTCD, ~VSSTRESN,
    "P01",    "WEIGHT",       80.9,
    "P01",    "HEIGHT",      189.2
  )

  expected_output <- input[1L, ]

  expect_dfs_equal(
    expected_output,
    filter_if(input, expr(VSTESTCD == "WEIGHT")),
    keys = c("USUBJID", "VSTESTCD")
  )
})

# contains_vars ----
## Test 6: returns TRUE for valid arguments ----
test_that("contains_vars Test 6: returns TRUE for valid arguments", {
  expect_true(contains_vars(exprs(USUBJID, PARAMCD)))
})

## Test 7: returns TRUE for valid arguments ----
test_that("contains_vars Test 7: returns TRUE for valid arguments", {
  expect_error(contains_vars(USUBJID))
})
# vars2chr ----
## Test 8: returns character vector ----
test_that("vars2chr Test 8: returns character vector", {
  expected <- c("STUDYID", "USUBJID")
  names(expected) <- c("", "")
  expect_equal(vars2chr(exprs(STUDYID, USUBJID)), expected)
})

# extract_vars ----
## Test 9: works with formulas (lhs) ----
test_that("extract_vars Test 9: works with formulas (lhs)", {
  expect_equal(
    object = extract_vars(AVAL ~ ARMCD + AGEGR1),
    expected = unname(exprs(AVAL))
  )
})

## Test 10: works with formulas (rhs) ----
test_that("extract_vars Test 10: works with formulas (rhs)", {
  expect_equal(
    object = extract_vars(AVAL ~ ARMCD + AGEGR1, side = "rhs"),
    expected = unname(exprs(ARMCD, AGEGR1))
  )
})

## Test 11: works with calls ----
test_that("extract_vars Test 11: works with calls", {
  fun <- mean
  expect_equal(
    object = extract_vars(expr({{ fun }}((BASE - AVAL) / BASE * 100, LLQ / 2))),
    expected = unname(exprs(BASE, AVAL, LLQ))
  )
})

# %or% ----
## Test 12: %or% works ----
test_that("extract_vars Test 12: %or% works", {
  input <- dplyr::tribble(
    ~USUBJID, ~AVAL,
    "P01",    2,
  )
  expect_equal(
    input,
    expected = input %>%
      dplyr::select(-AVAL) %>%
      dplyr::mutate(AVAL = sqrt("4") %or% 2)
  )
})

## Test 13: %or% deprecation message if function is called ----
test_that("extract_vars Test 13: %or% deprecation message if function is called", {
  expect_snapshot({
    input <- dplyr::tribble(
      ~USUBJID, ~AVAL,
      "P01",    2,
    )
    result <- input %>%
      dplyr::select(-AVAL) %>%
      dplyr::mutate(AVAL = sqrt("4") %or% 2)
  })
})

# valid_time_units ----
## Test 14: works as intended ----
test_that("valid_time_units Test 14: works as intended", {
  expect_equal(
    valid_time_units(),
    c("years", "months", "days", "hours", "minutes", "seconds")
  )
})


## Test 15: deprecation message if function is called ----
test_that("valid_time_units Test 15: deprecation message if function is called", {
  expect_snapshot({
    result <- valid_time_units()
  })
})
