% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DownloadRaindancer.R
\name{DownloadRaindancer}
\alias{DownloadRaindancer}
\title{Scrapes data from Raindancer user account for all logged sprinklers.
Beware: It only downloads the last 10.000 logs (~12 days).
Requirements: Java and Firefox must be installed on your machine.}
\usage{
DownloadRaindancer(
  sourcepath = NA,
  targetpath = NA,
  port = 4486L,
  client = NA,
  user = NA,
  pass = NA,
  waitfor = 3,
  nozzle_diameter = "25_4",
  target_crs = 32633,
  ff_vis = "no"
)
}
\arguments{
\item{sourcepath}{Path (string) to Firefox download folder. Look it up in your Firefox browser.}

\item{targetpath}{Path (string) to destination folder for downloaded csv-files from Raindancer.}

\item{port}{You need to open a port to let R and Java scrape the website´s data (default: 4486L).}

\item{client}{Raindancer client number}

\item{user}{Raindancer user account}

\item{pass}{Raindancer password}

\item{waitfor}{time to wait for loading websites. The quicker your computer and internet connection, the less it can be (integer). Default is 3.}

\item{nozzle_diameter}{diameter of nozzle in mm (string, e.g. 17_8 = 17.8 mm). Default is "25_4".}

\item{target_crs}{target crs}

\item{ff_vis}{choose whether Firefox runs visibly ("yes") or hidden ("no", default). If visible, increase the waiting time (e.g., to about 3 seconds).}
}
\value{
csv file for all irrigation events of all sprinklers, that are logged in Raindancer Account.
}
\description{
Scrapes data from Raindancer user account for all logged sprinklers.
Beware: It only downloads the last 10.000 logs (~12 days).
Requirements: Java and Firefox must be installed on your machine.
}
