\name{summary.warn}
\alias{summary.warn}
\title{
  Summaries of posterior weaning parameters
}
\description{
  \code{summary.warn} calculates simple summaries of posterior samples for the four weaning parameters, which is the maximum density estimators and its marginal probabilities, a joint probability for the combination of the maximum density weaning ages, mean squared distance between the measured and modeled nitrogen isotope ratio (d15N), number of non-adult individuals used, and number of particles used in sequential Monte Carlo (SMC) sampling.
}
\usage{
\method{summary}{warn}(object, \dots)
}
\arguments{
  \item{object}{an object of class \code{"warn"} generated by \code{\link{warn}}.}
  \item{\dots}{additional arguments affecting the summary produced.}
}
\value{
  \code{summary.warn} returns a list containing following components and those succeeded from \code{"warn"}:\cr
  \item{call}{the matched call.}
  \item{mde}{the maximum density estimators and the marginal probabilities.}
  \item{prob.2d.age}{the joint probability for the combination of the maximum density weaning ages.}
  \item{dist.mde}{the mean squared distance between the measured and modeled d15Ns.}
  \item{individual}{the number of non-adult individuals used.}
  \item{particle}{the number of particles used in SMC sampling.}
}
\references{
  Tsutaya, T., and Yoneda, M. (2013). Quantitative reconstruction of weaning ages in archaeological human populations using bone collagen nitrogen isotope ratios and approximate Bayesian computation. \emph{PLoS ONE} \bold{8}, e72327.
}
\seealso{
  \code{\link{WARN}}, \code{\link{warn}}, \code{\link{warnCI}}, \code{\link{warnProb}}, \code{\link{plot.warn}}
}
\examples{
## See ?warn for examples.
}
\keyword{math}

