% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qcond_gamma}
\alias{qcond_gamma}
\title{Conditional quantile function for gamma distribution}
\usage{
qcond_gamma(rnd, shape, rate, lower_bound, s_obs)
}
\arguments{
\item{rnd}{Vector of quantiles}

\item{shape}{The shape parameter}

\item{rate}{The rate parameter}

\item{lower_bound}{The lower bound to be used (current time)}

\item{s_obs}{is the survival observed up to lower_bound time,
normally defined from time 0 as 1 - pgamma(q = lower_bound, rate, shape) but may be different if parametrization has changed previously}
}
\value{
Estimate(s) from the conditional gamma distribution based on given parameters
}
\description{
Conditional quantile function for gamma distribution
}
\examples{
qcond_gamma(rnd = 0.5, shape = 1.06178, rate = 0.01108,lower_bound = 1, s_obs=0.8)
}
