% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TFCE_vertex_analysis.R
\name{TFCE_threshold}
\alias{TFCE_threshold}
\title{Thresholding TFCE output}
\usage{
TFCE_threshold(TFCEoutput, p = 0.05, atlas = 1, k = 20, VWR_check = TRUE)
}
\arguments{
\item{TFCEoutput}{An object containing the output from TFCE_vertex_analysis()}

\item{p}{A numeric object specifying the p-value to threshold the results (Default is 0.05)}

\item{atlas}{A numeric integer object corresponding to the atlas of interest.  1=Desikan, 2=Destrieux-148, 3=Glasser-360, 4=Schaefer-100, 5=Schaefer-200, 6=Schaefer-400. Set to \code{1} by default. This argument is ignored for hippocampal surfaces.}

\item{k}{Cluster-forming threshold (Default is 20)}

\item{VWR_check}{A boolean object specifying whether to check and validate system requirements. Default is TRUE.}
}
\value{
A list object containing the cluster level results, unthresholded t-stat map, thresholded t-stat map, and positive, negative and bidirectional cluster maps.
}
\description{
Threshold TFCE maps from the TFCE_vertex_analysis() output and identifies significant clusters at the desired threshold.
}
\examples{
model1_TFCE=readRDS(file = url(paste0("https://github.com/CogBrainHealthLab",
"/VertexWiseR/blob/main/inst/demo_data/model1_TFCE.rds?raw=TRUE")))

TFCEanalysis_output=TFCE_threshold(model1_TFCE, p=0.05, atlas=1,
VWR_check=FALSE)
TFCEanalysis_output$cluster_level_results
}
