% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/veWaning.R
\name{veWaning}
\alias{veWaning}
\title{Estimation of Vaccine Efficacy Ove Time}
\usage{
veWaning(
  data,
  L,
  ...,
  lag = 0,
  modelGam1 = NULL,
  modelGam2 = NULL,
  modelEntry = NULL,
  modelPsiGam1 = NULL,
  modelPsiGam2 = NULL,
  gFunc = NULL,
  v = NULL,
  minWgt = NULL,
  maxWgt = NULL,
  txName = "A",
  infectionTime = "U",
  entryTime = "E",
  Gamma = "Gam",
  unblindTime = "R",
  vaccinated = "Psi"
)
}
\arguments{
\item{data}{A data.frame object containing all relevant data.}

\item{L}{A numeric object. The analysis time.}

\item{...}{Ignored. Used only to require named inputs.}

\item{lag}{A numeric object. The lag time between the initial vaccine
dose and full efficacy.}

\item{modelGam1}{A formula object. The coxph model for Gamma = 1.
The LHS is set as the appropriate Surv() object internally. If a LHS
is provided, it is ignored.}

\item{modelGam2}{A formula object. The coxph model for Gamma = 2.
The LHS is set as the appropriate Surv() object internally. If a LHS
is provided, it is ignored.}

\item{modelEntry}{A formula object. The coxph model for entry times.
The LHS is set as the appropriate Surv() object internally. If a LHS
is provided, it is ignored.}

\item{modelPsiGam1}{A formula object. The logistic model for vaccination
for participants with Gamma = 1.
If a LHS is provided, it is ignored.}

\item{modelPsiGam2}{A formula object. The logistic model for vaccination
for participants with Gamma = 2.
If a LHS is provided, it is ignored.}

\item{gFunc}{A character object. The model of infection rates. Must be one
of \{'lin', 'piece', 'splin', 'spcub'\} for the linear,
piecewise constant, linear spline, and cubic spline models respectively}

\item{v}{A numeric vector. The knots or cut-offs to be used by gFunc.
If gFunc = 'lin', this input is ignored. For 'splin' and 'spcub', this
is the knots of the spline on (0,L). For 'piece', v is the cut-offs on 
(0,L). Note that this input should not include the extremes 0 and L.}

\item{minWgt}{A numeric object. If not NULL, the minimum non-zero value a 
weight can have, i.e., weight = max(minWgt, weight). If NULL, no
truncation of weights is performed.}

\item{maxWgt}{A numeric object. If not NULL, the maximum value a 
weight can have, i.e., weight = min(maxWgt, weight). If NULL, no
truncation of weights is performed.}

\item{txName}{A character object. The header of the column of data 
containing the treatment variable. Default value is 'A'.
Treatment must be coded as 0/1, where 1 indicates that participant
was vaccinated; 0 otherwise.}

\item{infectionTime}{A character object. The header of the column of data 
containing the time of infection on the scale of the calendar time. 
Default value is 'U'.}

\item{entryTime}{A character object. The header of the column of data 
containing the time of entry into the study on the scale of the
calendar time. Default value is 'E'.}

\item{Gamma}{A character object. The header of the column of data 
containing the category for the unblinding dynamic. 
Default value is 'Gam'.
Data must be 0/1/2, where 0 indicates infection occurs before requested/
offered unblinding; 1 indicates unblinding was requested by participant
prior to the commencement of participant decision clinic visits; 
and 2 indicates that unblinding occurred after the commencement of
participant decision clinic visits}

\item{unblindTime}{A character object. The header of the column of data 
containing the time to requested unblinding, participant  decision
clinic visit/requested unblinding, or infection, whichever comes first.
Default value is 'R'.}

\item{vaccinated}{A character object. The header of the column of data 
containing the indicator of vaccination, where 1 if participant is
vaccinated; 0 otherwise.
Default value is 'Psi'.}
}
\value{
A an S3 object of class "VEwaning", which comprises a list object
  containing 
  \item{theta}{A vector object containing the estimated theta parameters.}
  \item{cov}{The covariance estimated using the sandwich estimator.}
  \item{SE}{The standard error estimated using the sandwich estimator.}
  and attributes  "gFunc", "maxTau", "lag", and "v", which store
  details of the original analysis that are required for post-processing
  convenience functions ve() and plot(). See details for further
  information.
}
\description{
Implements methods for inference on potential waning of vaccine
   efficacy and for estimation of vaccine efficacy at a user-specified time
   after vaccination based on data from a randomized, double-blind,
   placebo-controlled vaccine trial in which participants may be unblinded
   and placebo subjects may be crossed over to the study vaccine.  The
   methods also allow adjustment for possible confounding via inverse
   probability weighting through specification of models for the trial
   entry process, unblinding mechanisms, and the probability an unblinded
   placebo participant accepts study vaccine. Tsiatis, A. A. and Davidian,
   M. (2021) <arXiv:2102.13103>
}
\details{
Note the infection time, U, can take 
  values NA or a value > L if the participant did not become infected.
 All other data must be complete.
 
The returned S3 object has 4 attributes needed for post-processing
 tools ve() and plot(). Specifically, "gFunc" is a character object
 specifying the model selected for the infection rate (input gFunc);
 "v", the knots or cut-offs to be used by gFunc (input v);
 "maxTau", the maximum vaccination time included in the analysis; and
 "lag", the lag time between the initial vaccine dose and full efficacy.
}
\examples{
data(veWaningData)

set.seed(1234)

ind <- sample(1:nrow(veWaningData), 2500)
# NOTE: This sample size is chosen for example only -- larger data sets
# should be used.

res <- veWaning(data = veWaningData[ind,], 
                L = 52,  
                lag = 6,  
                modelGam1 = ~ X1+X2+A+A:X1+A:X2, 
                modelGam2 = ~ X1+X2, 
                modelEntry = ~ X1+X2, 
                modelPsiGam1 = ~ X1+X2, 
                modelPsiGam2 = ~ X1+X2, 
                gFunc = 'piece', 
                v = c(15,30))
}
\references{
Tsiatis, A. A. and Davidian, M. (2021) Estimating Vaccine
  Efficacy Over Time After a Randomized Study is Unblinded. Submitted.
}
