% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{QMEDPOT}
\alias{QMEDPOT}
\title{Empirical estimate of QMED from peaks over threshold (POT) data}
\usage{
QMEDPOT(x, ppy)
}
\arguments{
\item{x}{numerical vector. POT data}

\item{ppy}{number of peaks per year in the POT data}
}
\description{
Estimates the median annual maximum flow (QMED) from peaks over threshold data
}
\details{
If there are multiple peaks per year, the peaks per year (ppy) argument is used to convert to the annual scale to derive QMED. If ppy is one, then the median of the POT sample is returned (the median of x).
}
\examples{
# Extract some POT data and estimate QMED
thames_pot <- POTextract(ThamesPQ[, c(1, 3)], thresh = 0.90)
QMEDPOT(thames_pot$peak, ppy = 1.867263)

}
\author{
Anthony Hammond
}
