% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_ship.R
\name{create_ship}
\alias{create_ship}
\title{Creates a Ship Object for Generating Theseus Plots}
\usage{
create_ship(
  data1,
  data2,
  y = "y",
  labels = c("Original", "Refitted"),
  ylab = NULL,
  digits = 3L,
  text_size = 1
)
}
\arguments{
\item{data1}{data frame representing the first group (e.g., the baseline or
"original" data).}

\item{data2}{data frame representing the second group (e.g., the comparison
or "refitted" data).}

\item{y}{column name specifying the outcome variable used to compute the rate
metric (default is \code{"y"}). Typically, this is a binary indicator
(e.g., 0/1) that is aggregated to form rates.}

\item{labels}{character vector of length 2 giving the labels for the two
groups. The first corresponds to \code{data1}, the second to \code{data2}.
Default is \code{c("Original", "Refitted")}.}

\item{ylab}{string specifying the y-axis label for plots. If \code{NULL}
(default), no label is displayed.}

\item{digits}{integer indicating the number of decimal places to use for
displaying numeric values (default is 3).}

\item{text_size}{numeric value specifying the relative size of text elements
in plots (default is 1.0).}
}
\value{
A \link{ShipOfTheseus} object, which can be used with \code{plot()}
  to create Theseus plots.
}
\description{
Creates a ship object, which serves as a container for data and methods to
generate Theseus plots for decomposing differences in rate metrics.
}
\examples{
library(dplyr)
library(TheseusPlot)

data <- nycflights13::flights |>
  filter(!is.na(arr_delay)) |>
  mutate(on_time = arr_delay <= 0)

data1 <- data |> filter(month == 1)
data2 <- data |> filter(month == 2)

create_ship(data1, data2, y = on_time)

}
