% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsqca_config_chart.R
\name{identify_epi}
\alias{identify_epi}
\title{Identify Essential Prime Implicants from multiple solutions}
\usage{
identify_epi(solutions)
}
\arguments{
\item{solutions}{List of solution vectors. Each element is a character
vector of terms for one solution.}
}
\value{
List with:
  \itemize{
    \item \code{epi} — Essential prime implicants (in all solutions)
    \item \code{spi} — Selective prime implicants (in some solutions)
    \item \code{n_solutions} — Number of solutions
  }
}
\description{
Finds terms that appear in ALL solutions (EPIs) versus terms that
appear in only some solutions (SPIs).
}
\examples{
solutions <- list(
  c("A*B", "C", "D"),
  c("A*B", "C", "E"),
  c("A*B", "C", "F")
)
result <- identify_epi(solutions)
# result$epi = c("A*B", "C")
# result$spi = c("D", "E", "F")

}
