% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLikSubjectDisplacements.R
\name{logLikSubjectDisplacements}
\alias{logLikSubjectDisplacements}
\title{Likelihood displacements for the model}
\usage{
logLikSubjectDisplacements(
  model,
  disp_thrh = NA,
  label_angle = 0,
  var_name = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{An object of class "lme" representing the linear mixed-effects model fitted by \code{\link[=lmmModel]{lmmModel()}}.}

\item{disp_thrh}{Numeric value indicating the threshold of log-likelihood displacement. If not specified, the threshold is set to three times the mean of the log-likelihood
displacement values.}

\item{label_angle}{Numeric value indicating the angle for the label of subjects with a log-likelihood displacement greater than \code{disp_thrh}.}

\item{var_name}{Name of the variable for the weights of the model in the case that a variance structure has been specified using \code{\link[nlme:varIdent]{nlme::varIdent()}}.
(See examples in \code{\link[=lmmModel]{lmmModel()}}).}

\item{verbose}{Logical indicating if subjects with a log-likelihood displacement greater than \code{disp_thrh} should be printed to the console.}

\item{...}{Extra arguments, if any, for \link[lattice:panel.xyplot]{lattice::panel.xyplot}.}
}
\value{
Returns a plot of the log-likelihood displacement values for each subject, indicating those subjects
whose contribution is greater than \code{disp_thrh}.
}
\description{
\code{logLikSubjectDisplacements} allows the user to evaluate the log-likelihood displacement for each subject,
indicating the influence of every subject to the model.
}
\details{
The evaluation of the log-likelihood displacement is based in the analysis proposed in Verbeke and Molenberghs (2009) and Gałecki and Burzykowski (2013).
First, a list of models fitted to leave-one-subject-out datasets are obtained. Then, for each model, the maximum likelihood estimate obtained by fitting the
model to all data and the maximum likelihood estimate obtained by fitting the model to the data with the \eqn{i}-th subject removed are obtained and used for the
log-likelihood displacement calculation. The likelihood displacement, \eqn{LDi} , is defined as twice the difference between the log-likelihood computed at a
maximum and displaced values of estimated parameters (Verbeke and Molenberghs (2009), Gałecki and Burzykowsk (2013)):

\deqn{LD_i \equiv 2 \times \Bigr[\ell_\textrm{Full}(\widehat{\Theta};\textrm{y})-\ell_\textrm{Full}(\widehat{\Theta}_{(-i)};\textrm{y})\Bigr]}

where \eqn{\widehat{\Theta}} is the maximum-likelihood estimate of \eqn{\Theta} obtained by fitting the model to all data, while \eqn{\widehat{\Theta}_{-i}} is
the maximum-likelihood estimate obtained by fitting the model to the data with the \eqn{i}-subject excluded.
}
\examples{
# Load the example data
data(grwth_data)
# Fit the model
lmm <- lmmModel(
  data = grwth_data,
  sample_id = "subject",
  time = "Time",
  treatment = "Treatment",
  tumor_vol = "TumorVolume",
  trt_control = "Control",
  drug_a = "DrugA",
  drug_b = "DrugB",
  combination = "Combination"
  ) 
# Obtain log-likelihood displacement for each subject
logLikSubjectDisplacements(model = lmm)
# Modifying the threshold for log-likelihood displacement
logLikSubjectDisplacements(model = lmm, disp_thrh = 1)

# Calculating the log-likelihood contribution in a model with a variance structure specified
lmm_var <- lmmModel(
  data = grwth_data,
  sample_id = "subject",
  time = "Time",
  treatment = "Treatment",
  tumor_vol = "TumorVolume",
  trt_control = "Control",
  drug_a = "DrugA",
  drug_b = "DrugB",
  combination = "Combination",
  weights = nlme::varIdent(form = ~ 1|SampleID)
  ) 
# Calculate the log-likelihood contribution
logLikSubjectDisplacements(model = lmm, var_name = "SampleID")

}
\references{
\itemize{
\item Andrzej Galecki & Tomasz Burzykowski (2013) \emph{Linear Mixed-Effects Models Using R: A Step-by-Step Approach} First Edition. Springer, New York. ISBN 978-1-4614-3899-1
\item Verbeke, G. & Molenberghs, G. (2000). \emph{Linear Mixed Models for Longitudinal Data}. Springer New York. https://doi.org/10.1007/978-1-4419-0300-6
}
}
