% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_target.R
\name{prop_target}
\alias{prop_target}
\title{prop_target}
\usage{
prop_target(
  minLS = NULL,
  maxLS = NULL,
  Lc = NULL,
  M = NULL,
  growth_model = c("vb", "gompertz", "schnute"),
  Linf = NULL,
  K = NULL,
  l0 = 0,
  tmax = NULL,
  Gom_Linf = NULL,
  Gom_K = NULL,
  Gom_l0 = NULL,
  g1 = NULL,
  g2 = NULL,
  l2 = NULL,
  Lmin = NULL,
  plot = FALSE,
  length_units = NULL
)
}
\arguments{
\item{minLS, maxLS}{Numeric. Minimum and maximum harvest slot limits (same units as length).}

\item{Lc}{Numeric. Lower cutoff; individuals below \code{Lc} are \emph{not exploitable}.}

\item{M}{Numeric or \code{NULL}. Natural mortality. If \code{NULL},
defaults to \eqn{M = 4.899\,t_{max}^{-0.916}}.}

\item{growth_model}{Character. One of \code{"vb"}, \code{"gompertz"}, \code{"schnute"}.}

\item{Linf, K, l0}{VB parameters; \code{l0} is the start length (default 0).}

\item{tmax}{Numeric. Maximum age used to determine \eqn{l(t_{max})} and set the upper integration bound.}

\item{Gom_Linf, Gom_K, Gom_l0}{Gompertz parameters; requires \code{0 < Gom_l0 < Gom_Linf}.}

\item{g1, g2, l2}{Schnute parameters; \code{l2 = l(t_{max})}; requires \code{g1 > 0}, \code{l2 > 0}, \code{g2 != 0}.}

\item{Lmin}{Optional numeric. Lower bound for the curve grid. If \code{NULL} it uses the
model’s start length (\code{l0}, \code{Gom_l0}, or \code{0}).}

\item{plot}{Logical. If \code{TRUE}, return a \pkg{ggplot2} visual; default \code{FALSE}.}

\item{length_units}{Optional character scalar. Units to display in the x-axis
label when \code{plot = TRUE} (e.g., \code{"cm"} or \code{"mm"}). If \code{NULL} (default),
the label is simply \code{"Length"}.}
}
\value{
If \code{plot = FALSE} (default): numeric scalar (the targeted proportion).
If \code{plot = TRUE}: list with \code{proportion} and \code{plot} (a ggplot object).
}
\description{
Calculates the proportion of normalized survivorship \eqn{S(L)} falling inside
harvest slot limits \code{[minLS, maxLS]} relative to the exploitable population
(>\code{L_c}), where \eqn{S(L) = \exp(-M \, t(L))}
and \eqn{t(L)} is the inverse age-from-length for a chosen growth model.
}
\details{
Supported growth models (reparameterized to avoid negative length-at-age-0
and to give exact \eqn{t(L_{start})=0}):
\itemize{
\item \strong{von Bertalanffy (VB)} with start length \eqn{l_0}:
\deqn{t(l) = -\frac{1}{K}\ln\!\left(\frac{L_\infty - l}{L_\infty - l_0}\right), \quad
        l(t) = L_\infty\!\left(1 - (1-l_0/L_\infty)\,e^{-Kt}\right).}
\item \strong{Gompertz} with start length \eqn{l_0} (requires \eqn{0 < l_0 < L_\infty}):
\deqn{t(l) = -\frac{1}{K}\ln\!\left(\frac{\ln(l/L_\infty)}{\ln(l_0/L_\infty)}\right), \quad
        l(t) = L_\infty\,(l_0/L_\infty)^{e^{-Kt}}.}
\item \strong{Schnute} with \eqn{l(0)=0} and \eqn{l(t_{max})=l_2}:
\deqn{t(l) = -\frac{1}{g_1}\ln\!\left(1 - \frac{l^{g_2}}{l_2^{g_2}}\,(1-e^{-g_1 t_{max}})\right), \quad
        l(t) = \left(\frac{l_2^{g_2}}{1-e^{-g_1 t_{max}}}\,(1-e^{-g_1 t})\right)^{1/g_2}.}
}

Survivorship is normalized at the model start so that \eqn{S(L_{start})=1}:
\code{l0} for vB, \code{Gom_l0} for Gompertz (requires \code{0 < Gom_l0 < Gom_Linf}),
and \eqn{0} for Schnute.

Targeted proportion:
\deqn{\frac{\int_{\max(minLS,L_c)}^{\min(maxLS,\,l(t_{max}))} S(L)\,dL}{
             \int_{\max(L_c,\,L_{start})}^{l(t_{max})} S(L)\,dL}.}
We clamp only near the upper limit to avoid \code{log(0)} and never shift the start,
preserving \eqn{t(L_{start})=0}.
}
\examples{
# Numeric only
prop_target(minLS=120, maxLS=240, Lc=80,
  growth_model="vb", Linf=405, K=0.118, l0=0, tmax=34, plot=FALSE)

\donttest{
# With plot (requires ggplot2)
out <- prop_target(minLS=120, maxLS=240, Lc=80,
  growth_model="schnute", g1=0.2, g2=0.2, l2=405, tmax=34, plot=TRUE, length_units = "mm")
out$plot
}

}
