% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeasEpi_Par_Est.R
\name{SeasEpi_Par_Est}
\alias{SeasEpi_Par_Est}
\title{SeasEpi for Real Data}
\usage{
SeasEpi_Par_Est(
  data,
  adjacency_matrix,
  DimCovInf,
  DimCovSus,
  tau0,
  lambda0,
  alphaS0,
  delta0,
  alphaT0,
  InfPrd,
  IncPrd,
  NIterMC,
  NIterMCECM,
  zeta10,
  zeta20,
  T_cycle
)
}
\arguments{
\item{data}{Dataset. The dataset should exactly match the \code{data} file in the data folder, including all the columns with the same names.}

\item{adjacency_matrix}{Adjacency matrix representing the regions in the study area (0 if no connection between regions)}

\item{DimCovInf}{Dimensions of the individual infectivity covariate}

\item{DimCovSus}{Dimensions of the area-level susceptibility to initial infection covariate}

\item{tau0}{Initial value for spatial precision}

\item{lambda0}{Initial value for spatial dependence}

\item{alphaS0}{Initial value for the susceptibility intercept}

\item{delta0}{Initial value for the spatial decay parameter}

\item{alphaT0}{Initial value for the infectivity intercept}

\item{InfPrd}{Infectious period that can be obtained either from the literature or by fitting an SEIRS model to the data}

\item{IncPrd}{Incubation period that can be obtained either from the literature or by fitting an SEIRS model to the data}

\item{NIterMC}{Number of MCMC iterations}

\item{NIterMCECM}{Number of MCECM iterations}

\item{zeta10}{Initial value for the amplitude of the seasonal oscillation parameter (sin part)}

\item{zeta20}{Initial value for the phase of the seasonal oscillation parameter (cos part)}

\item{T_cycle}{The duration of a complete seasonal cycle (e.g., 12 months for an annual cycle)}
}
\value{
\code{alphaS} Estimate of alpha S

\code{BetaCovInf} Estimate of beta vector for the individual level infection covariate

\code{BetaCovSus} Estimate of beta vector for the areal susceptibility to first infection covariate

\code{alphaT} Estimate of alpha T

\code{delta} Estimate of delta

\code{zeta1} Estimate of zeta1

\code{zeta2} Estimate of zeta2

\code{tau1} Estimate of tau

\code{lambda1} Estimate of lambda

\code{AIC} AIC of the fitted GDILM SEIRS
}
\description{
This function applies the spatiotemporal individual-level model of seasonal infectious disease transmission within the Susceptible-Exposed-Infectious-Recovered-Susceptible (SEIRS) framework, to real data. It employs a likelihood based Monte Carlo Expectation Conditional Maximization (MCECM) algorithm for parameter estimation and AIC calculation. This function requires two dataframes, named \code{data} and \code{adjacency_matrix}, along with the necessary parameters. Detailed information on the structure of these two datasets is provided in the package.
}
\examples{
\donttest{
data(data)
data(adjacency_matrix)
SeasEpi_Par_Est(data,adjacency_matrix,2,2,0.5, 0.5, 1, 0.1, 1, 1, 1, 20, 2,0.2,0.2,5)
}

}
