% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_MUSICBearing2GeographicalBearing}
\alias{seasonder_MUSICBearing2GeographicalBearing}
\title{Convert MUSIC Bearings to Geographic Bearings}
\usage{
seasonder_MUSICBearing2GeographicalBearing(bearings, seasonder_apm_object)
}
\arguments{
\item{bearings}{A list of numeric vectors containing MUSIC bearings in degrees. Each vector corresponds to a set of bearings relative to the antenna.}

\item{seasonder_apm_object}{A \code{SeaSondeRAPM} object containing the antenna's metadata, including the antenna's bearing.}
}
\value{
A list of numeric vectors containing the geographic bearings in degrees.
}
\description{
This function converts MUSIC bearings (relative to the antenna) into geographic bearings using the antenna's bearing information from a \code{SeaSondeRAPM} object.
}
\details{
The geographic bearing is calculated by:
\enumerate{
\item Multiplying the MUSIC bearings by -1 to invert their direction.
\item Adjusting the angles to the range [0, 360) using modulo 360.
\item Adding the antenna bearing to each value and wrapping the result to the range [0, 360) again using modulo 360.
}

The formula for each bearing is: \eqn{geo_bearing = ((-1 * music_bearing \\\%\\\% 360) + antenna_bearing) \\\%\\\% 360}.
}
\seealso{
\itemize{
\item \code{\link{seasonder_getSeaSondeRAPM_AntennaBearing}}
\item \code{\link[magrittr]{\%>\%}}
\item \code{\link[purrr]{map}}
}
}
