% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe_error_handling.R
\name{s_possibly}
\alias{s_possibly}
\title{Safe Possibly - Wrap Function to Return Default on Error}
\usage{
s_possibly(.f, otherwise, quiet = TRUE)
}
\arguments{
\item{.f}{A function to wrap for safe execution.}

\item{otherwise}{Default return value when an error occurs.}

\item{quiet}{Logical. Hide errors from console if TRUE.}
}
\value{
A function that returns the result or the default value.
}
\description{
Drop-in replacement for purrr::possibly that returns a default value
when an error occurs instead of throwing the error.
}
\examples{
safe_log <- s_possibly(log, otherwise = NA)
safe_log(10) # Returns 2.30
safe_log("a") # Returns NA

}
