% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FormulaSelection.R
\name{FormulaSelection.default}
\alias{FormulaSelection.default}
\alias{FormulaSelection}
\alias{formula_selection}
\title{Limit matrix or data frame to selected model terms}
\usage{
\method{FormulaSelection}{default}(x, formula, intercept = NA, logical = FALSE)

FormulaSelection(x, formula, intercept = NA, logical = FALSE)

formula_selection(x, formula, intercept = NA, logical = FALSE)
}
\arguments{
\item{x}{Model matrix or a data frame}

\item{formula}{Formula representing the limitation
or character string(s) to be converted to a formula (see details)}

\item{intercept}{Parameter that specifies whether a possible intercept term (overall total) should be included in the output.
Default is \code{TRUE} when a formula is input. Otherwise, see details.}

\item{logical}{When \code{TRUE}, the logical selection vector is returned.}
}
\value{
Limited model matrix or a data frame
}
\description{
For use with output from \code{\link{ModelMatrix}} or data frames derived from such output.
It is a generic function which means that methods for other input objects can be added.
}
\details{
The selection is based on \code{startCol} or \code{startRow} attribute in input \code{x}.

With \strong{formula as character}:
\itemize{
\item \strong{\code{~}} is included:
Input is converted by \code{as.formula} and default intercept is \code{TRUE}.
\item \strong{\code{~}} is not included:
Internally, input data is converted to a formula by adding \code{~} and possibly \code{+}'s when the length is \verb{>1}.
Default intercept is \code{FALSE} unless \code{"1"} or \code{"(Intercept)"} (is changed internally to \code{"1"}) is included.
}
}
\note{
\code{formula_selection} and \code{FormulaSelection} are identical
}
\examples{
z <- SSBtoolsData("sprt_emp_withEU")
z$age[z$age == "Y15-29"] <- "young"
z$age[z$age == "Y30-64"] <- "old"

x <- ModelMatrix(z, formula = ~age * year)

FormulaSelection(x, "age")
FormulaSelection(x, ~year)
FormulaSelection(x, ~year:age)

# x1, x2, x3, x4 and x4 are identical
x1 <- FormulaSelection(x, ~age)
x2 <- FormulaSelection(x, "~age")
x3 <- FormulaSelection(x, "age", intercept = TRUE)
x4 <- FormulaSelection(x, c("1", "age"))
x5 <- FormulaSelection(x, c("(Intercept)", "age"))


a <- ModelMatrix(z, formula = ~age * geo + year, crossTable = TRUE)
b <- cbind(as.data.frame(a$crossTable), 
           sum = (Matrix::t(a$modelMatrix) \%*\% z$ths_per)[, 1], 
           max = DummyApply(a$modelMatrix, 
           z$ths_per, max))
rownames(b) <- NULL
attr(b, "startRow") <- attr(a$modelMatrix, "startCol", exact = TRUE)

FormulaSelection(b, ~geo * age)
FormulaSelection(b, "age:geo")
FormulaSelection(b, ~year - 1)
FormulaSelection(b, ~geo:age, logical = TRUE)
}
