% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxpro.R
\name{maxpro.crit}
\alias{maxpro.crit}
\title{Maximum projection (MaxPro) criterion}
\usage{
maxpro.crit(design, delta = 0)
}
\arguments{
\item{design}{the design matrix.}

\item{delta}{a small value added to the denominator of the maximum projection criterion. By default it is set as zero.}
}
\value{
the MaxPro criterion of the design.
}
\description{
This function calculates the MaxPro criterion of a design.
}
\details{
\code{maxpro.crit} calculates the MaxPro criterion of a design. The MaxPro criterion for a design \eqn{D=[\bm x_1, \dots, \bm x_n]^T} is defined as \deqn{\left\{\frac{1}{{n\choose 2}}\sum_{i=1}^{n-1}\sum_{j=i+1}^{n}\frac{1}{\prod_{l=1}^p[(x_{il}-x_{jl})^2+ \delta]}\right\}^{1/p},} where \eqn{p} is the dimension of the design (Joseph, V. R., Gul, E., & Ba, S. 2015).
}
\examples{
n = 20
p = 3
D = randomLHD(n, p)
maxpro.crit(D)

}
\references{
Joseph, V. R., Gul, E., & Ba, S. (2015). Maximum projection designs for computer experiments. Biometrika, 102(2), 371-380.
}
