% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{plot.paths}
\alias{plot.paths}
\title{Visualize the paths of an SDTree or SDForest}
\usage{
\method{plot}{paths}(x, plotly = FALSE, selection = NULL, sqrt_scale = FALSE, ...)
}
\arguments{
\item{x}{A \code{paths} object}

\item{plotly}{If TRUE the plot is returned interactive using plotly. Might be slow for large data.}

\item{selection}{A vector of indices of the covariates to be plotted. 
Can be used to plot only a subset of the covariates in case of many covariates.}

\item{sqrt_scale}{If TRUE the y-axis is on a square root scale.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A \code{ggplot} object with the variable importance for different regularization.
If the \code{path} object includes a cp_min value, a black dashed line is
added to indicate the out-of-bag optimal variable selection.
}
\description{
This function visualizes the variable importance of an SDTree or SDForest
for different complexity parameters. Both the regularization path and
the stability selection path can be visualized.
}
\examples{
set.seed(1)
n <- 10
X <- matrix(rnorm(n * 5), nrow = n)
y <- sign(X[, 1]) * 3 + sign(X[, 2]) + rnorm(n)
model <- SDTree(x = X, y = y, Q_type = 'no_deconfounding', cp = 0.5)
paths <- regPath(model)
plot(paths)
\donttest{
plot(paths, plotly = TRUE)
}
}
\seealso{
\code{\link{regPath}} \code{\link{stabilitySelection}}
}
\author{
Markus Ulmer
}
