% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend_functions.R
\name{tsEvaTransformSeriesToStationaryTrendOnly}
\alias{tsEvaTransformSeriesToStationaryTrendOnly}
\title{tsEvaTransformSeriesToStationaryTrendOnly}
\usage{
tsEvaTransformSeriesToStationaryTrendOnly(timeStamps, series, timeWindow)
}
\arguments{
\item{timeStamps}{A vector of time stamps for the time series.}

\item{series}{The original time series.}

\item{timeWindow}{The size of the time window used for detrending.}
}
\value{
A list containing the following elements:
\describe{
\item{\code{runningStatsMulteplicity}}{The running statistics multiplicity.}
\item{\code{stationarySeries}}{The transformed stationary series.}
\item{\code{trendSeries}}{The trend series.}
\item{\code{trendSeriesNonSeasonal}}{The non-seasonal trend series.}
\item{\code{trendError}}{The error on the trend.}
\item{\code{stdDevSeries}}{The slowly varying standard deviation series.}
\item{\code{stdDevSeriesNonSeasonal}}{The non-seasonal slowly varying standard deviation series.}
\item{\code{stdDevError}}{The error on the standard deviation.}
\item{\code{timeStamps}}{The time stamps.}
\item{\code{nonStatSeries}}{The original non-stationary series.}
\item{\code{statSer3Mom}}{The third moment of the transformed stationary series.}
\item{\code{statSer4Mom}}{The fourth moment of the transformed stationary series.}
}
}
\description{
\code{tsEvaTransformSeriesToStationaryTrendOnly} is the original detrending
function implemented in Mentaschi et al.(2016).
It takes a time series and transforms it into a stationary one.
It computes the trend as a running average of the time series,
the slowly varying amplitude as its standard deviation, and other statistical measures.
}
\examples{
timeAndSeries <- ArdecheStMartin
timeStamps <- ArdecheStMartin[,1]
series <- ArdecheStMartin[,2]
timeWindow <- 30*365 # 30 years
#select only the 5 latest years
yrs <- as.integer(format(timeStamps, "\%Y"))
tokeep <- which(yrs>=2015)
timeStamps <- timeStamps[tokeep]
series <- series[tokeep]
timeWindow <- 365 # 1 year
result <- tsEvaTransformSeriesToStationaryTrendOnly(timeStamps, series, timeWindow)
plot(result$trendSeries)
}
