% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{tsEvaFillSeries}
\alias{tsEvaFillSeries}
\title{Fill missing values in a time series using a moving average approach.}
\usage{
tsEvaFillSeries(timeStamps, series)
}
\arguments{
\item{timeStamps}{A vector of timestamps.}

\item{series}{A vector representing the time series with missing values.}
}
\value{
A vector with missing values filled using a moving average approach.
}
\description{
This function takes a vector of timestamps and a corresponding series with missing values,
and fills the missing values by taking the average of the surrounding values.
}
\examples{
timeStamps <- c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)
series <- c(1, 2, NA, 4, 5, NA, 7, 8, NA, 10)
filledSeries <- tsEvaFillSeries(timeStamps, series)
filledSeries

}
