% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eva_functions.R
\name{tsEvaComputeReturnLevelsGPD}
\alias{tsEvaComputeReturnLevelsGPD}
\title{tsEvaComputeReturnLevelsGPD}
\usage{
tsEvaComputeReturnLevelsGPD(
  epsilon,
  sigma,
  threshold,
  epsilonStdErr,
  sigmaStdErr,
  thresholdStdErr,
  nPeaks,
  sampleTimeHorizon,
  returnPeriods
)
}
\arguments{
\item{epsilon}{The shape parameter of the GPD.}

\item{sigma}{The scale parameter of the GPD.}

\item{threshold}{The threshold parameter of the GPD.}

\item{epsilonStdErr}{The standard error of the shape parameter.}

\item{sigmaStdErr}{The standard error of the scale parameter.}

\item{thresholdStdErr}{The standard error of the threshold parameter.}

\item{nPeaks}{The number of peaks used to estimate the parameters.}

\item{sampleTimeHorizon}{The time horizon of the sample in the same units as the return periods (e.g., years).}

\item{returnPeriods}{The return periods for which to compute the return levels.}
}
\value{
A list containing the following components:
\describe{
\item{\code{returnLevels}}{A vector of return levels corresponding to the specified return periods.}
\item{\code{returnLevelsErr}}{A vector of standard errors for the return levels.}
}
}
\description{
#' \code{tsEvaComputeReturnLevelsGPD}is a function that
compute the return levels for a Generalized Pareto Distribution (GPD)
using the parameters of the distribution and their standard errors.
}
\details{
sampleTimeHorizon and returnPeriods must be in the same units, e.g. years
}
\examples{
# Example usage with some sample data
epsilon <- c(0.1)
sigma <- c(2.3)
threshold <- c(1.3)
epsilonStdErr <- c(0.01)
sigmaStdErr <- c(0.11)
thresholdStdErr <- c(0.011)
returnPeriodsInDts <- c( 5, 10, 20, 50)
nPeaks=70
SampleTimeHorizon=70
results <- tsEvaComputeReturnLevelsGPD(epsilon, sigma, threshold, epsilonStdErr,
sigmaStdErr, thresholdStdErr, nPeaks, SampleTimeHorizon, returnPeriodsInDts)
head(results$returnLevels)
head(results$returnLevelsErr)
}
