% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vs_sintax.R
\name{taxonomy_tree}
\alias{taxonomy_tree}
\title{Make a taxonomy tree}
\usage{
taxonomy_tree(taxonomy_table, confidence = NULL)
}
\arguments{
\item{taxonomy_table}{(Required). A data.frame with sequences and taxonomy
information, see \emph{Details}.}

\item{confidence}{(Optional). A threshold value used to replace taxa with
confidence scores below this to \code{NA}.}
}
\value{
A phylo object, see \code{\link[ape]{nj}}.
}
\description{
Creates a phylo object based on taxonomy
}
\details{
In some data analyses involving OTU data a phylogenetic tree
describing the relatedness of the OTUs is required. To construct such trees
you typically need to make a multiple alignment of the sequences behind each
OTU, which is a huge job.

An alternative is then to simply use the taxonomy, and create a
'taxonomy-tree' instead of a phylogenetic tree. This function creates such a
tree from a taxonomy table of the same format as output by
\code{\link{vs_sintax}}.

Distances between two OTUs reflect how high up in the taxonomy they have a
common taxon, i.e if they are of the same species the distance is 0, if
different species but same genus the distance is 1 etc. Note that \code{NA}s
in the taxonomy are not matched, increasing the distances, i.e if two OTUs
have \code{NA} as species and genus, but share family, the distance is 2.

The \code{confidence} sets a threshold for replacing low-confidence taxa to
\code{NA}. For this to work the \code{taxonomy_table} must have columns with
such confidence scores i.e. columns domain_score, phylum_score,
...species_score. If the species_score is below \code{confidence} the
corresponding species name is set to \code{NA}, and similar for all ranks.
The default is to ignore this confidence (\code{confidence = NULL}).

From these distances a Neighbor Joining tree is built using
\code{\link[ape]{nj}}.
}
\examples{
\dontrun{
# Assign taxonomy with sintax
db.file <- file.path(file.path(path.package("Rsearch"), "extdata"),
                     "sintax_db.fasta")
fasta.file <- file.path(file.path(path.package("Rsearch"), "extdata"),
                     "small.fasta")
tax.tbl <- vs_sintax(fasta_input = fasta.file, database = db.file)

# Making tree
tax.tree <- taxonomy_tree(tax.tbl)
}

}
\references{
\url{https://www.biorxiv.org/content/10.1101/074161v1}
}
