% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pxlib_metadata.R
\name{pxlib_metadata}
\alias{pxlib_metadata}
\title{Get Metadata from a Paradox Database File}
\usage{
pxlib_metadata(pxdoc)
}
\arguments{
\item{pxdoc}{An object of class \code{pxdoc_t}, representing an open Paradox file
connection, obtained from \code{pxlib_open_file()}.}
}
\value{
A list containing:
\item{num_records}{The total number of records in the database.}
\item{num_fields}{The total number of fields (columns).}
\item{encoding}{The character encoding specified in the file header (e.g., "CP1251").}
\item{fields}{A data frame with details for each field, with names recoded to UTF-8.}
}
\description{
Retrieves metadata from an open Paradox file handle without reading the
entire dataset.
}
\examples{
db_path <- system.file("extdata", "country.db", package = "Rparadox")
pxdoc <- pxlib_open_file(db_path)
if (!is.null(pxdoc)) {
  metadata <- pxlib_metadata(pxdoc)
  print(metadata)
  pxlib_close_file(pxdoc)
}
}
