#' Functions for converting resolutions: ppi and ppcm
#'
#' \code{ppcm2ppi} - Converts a resolution given in pixels per cm to pixels
#' per inch.
#'
#' @param ppcm Numeric value or numeric vector of resolutions in ppcm to be
#' converted to ppi.
#'
#' @return \code{ppcm2ppi} Numeric value or numeric vector of resolutions in
#' ppi.
#'
#' @export
#' @rdname convert_ppi_ppcm
#'
#' @examples
#' ppcm2ppi(2)
ppcm2ppi <- function(ppcm) {
  ppi <- ppcm * 2.54
  return(ppi)
}
#' Functions for converting resolutions: ppi and ppcm
#'
#' \code{ppi2ppcm} - Converts a resolution given in pixels per inch to pixels
#' per cm.
#'
#' @param ppi Numeric value or numeric vector of resolutions in ppi to be
#' converted to ppcm.
#'
#' @return \code{ppi2ppcm} Numeric value or numeric vector of resolutions in
#' ppcm.
#'
#' @export
#' @rdname convert_ppi_ppcm
#'
#' @examples
#' ppi2ppcm(2)
ppi2ppcm <- function(ppi) {
  ppcm <- ppi * 0.393701
  return(ppcm)
}
