% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peer.q.R
\name{qpeer.sim}
\alias{qpeer.sim}
\title{Simulating Linear Models with Quantile Peer Effects}
\usage{
qpeer.sim(
  formula,
  Glist,
  tau,
  parms,
  lambda,
  beta,
  epsilon,
  structural = FALSE,
  init,
  type = 7,
  tol = 1e-10,
  maxit = 500,
  details = TRUE,
  data
)
}
\arguments{
\item{formula}{An object of class \link[stats]{formula}: a symbolic description of the model. \code{formula} should be specified as, for example, \code{~ x1 + x2},
where \code{x1} and \code{x2} are control variables, which can include contextual variables such as averages or quantiles among peers.}

\item{Glist}{The adjacency matrix. For networks consisting of multiple subnets (e.g., schools), \code{Glist} must be a list of subnets, with the \code{m}-th element being an \eqn{n_m \times n_m} adjacency matrix, where \eqn{n_m} is the number of nodes in the \code{m}-th subnet.}

\item{tau}{The vector of quantile levels.}

\item{parms}{A vector defining the true values of \eqn{(\lambda', \beta')'}, where \eqn{\lambda} is a vector of \eqn{\lambda_{\tau}} for each quantile level \eqn{\tau}.
The parameters \eqn{\lambda} and \eqn{\beta} can also be specified separately using the arguments \code{lambda} and \code{beta}. For the structural model,
\eqn{\lambda = (\lambda_2, \lambda_{\tau_1}, \lambda_{\tau_2}, \dots)^{\prime}} (see the Details section of \code{\link{qpeer}}).}

\item{lambda}{The true value of the vector \eqn{\lambda}.}

\item{beta}{The true value of the vector \eqn{\beta}.}

\item{epsilon}{A vector of idiosyncratic error terms. If not specified, it will be simulated from a standard normal distribution (see the model specification in the Details section of \code{\link{qpeer}}).}

\item{structural}{A logical value indicating whether simulations should be performed using the structural model. The default is the reduced-form model (see the Details section of \code{\link{qpeer}}).}

\item{init}{An optional initial guess for the equilibrium.}

\item{type}{An integer between 1 and 9 selecting one of the nine quantile algorithms used to compute peer quantiles (see the \link[stats]{quantile} function).}

\item{tol}{The tolerance value used in the Fixed Point Iteration Method to compute the outcome \code{y}. The process stops if the \eqn{\ell_1}-distance
between two consecutive values of \code{y} is less than \code{tol}.}

\item{maxit}{The maximum number of iterations for the Fixed Point Iteration Method.}

\item{details}{A logical value indicating whether to save the indices and weights of the two peers whose weighted average determines the quantile.}

\item{data}{An optional data frame, list, or environment (or an object that can be coerced by \link[base]{as.data.frame} to a data frame) containing the variables
in the model. If not found in \code{data}, the variables are taken from \code{environment(formula)}, typically the environment from which \code{sim.qpeer} is called.}
}
\value{
A list containing:
\item{y}{The simulated variable.}
\item{qy}{Quantiles of the simulated variable among peers.}
\item{epsilon}{The idiosyncratic error.}
\item{index}{The indices of the two peers whose weighted average gives the quantile.}
\item{weight}{The weights of the two peers whose weighted average gives the quantile.}
\item{iteration}{The number of iterations before convergence.}
}
\description{
\code{qpeer.sim} simulates the quantile peer effect models developed by Houndetoungan (2025).
}
\examples{
set.seed(123)
ngr  <- 50
nvec <- rep(30, ngr)
n    <- sum(nvec)
G    <- lapply(1:ngr, function(z){
  Gz <- matrix(rbinom(nvec[z]^2, 1, 0.3), nvec[z])
  diag(Gz) <- 0
  Gz
}) 
tau  <- seq(0, 1, 0.25)
X    <- cbind(rnorm(n), rpois(n, 2))
l    <- c(0.2, 0.1, 0.05, 0.1, 0.2)
b    <- c(2, -0.5, 1)

out  <- qpeer.sim(formula = ~ X, Glist = G, tau = tau, lambda = l, beta = b)
summary(out$y)
out$iteration
}
\references{
Houndetoungan, A. (2025). Quantile peer effect models. arXiv preprint arXiv:2405.17290, \doi{10.48550/arXiv.2506.12920}.

Hyndman, R. J., & Fan, Y. (1996). Sample quantiles in statistical packages. The American Statistician, 50(4), 361-365, \doi{10.1080/00031305.1996.10473566}.
}
\seealso{
\code{\link{qpeer}}, \code{\link{qpeer.instruments}}
}
