% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/instruments.R
\name{qpeer.instruments}
\alias{qpeer.instruments}
\alias{qpeer.instrument}
\alias{qpeer.inst}
\alias{qpeer.insts}
\title{Computing Instruments for Linear Models with Quantile Peer Effects}
\usage{
qpeer.instruments(
  formula,
  Glist,
  tau,
  type = 7,
  data,
  max.distance = 1,
  checkrank = FALSE,
  tol = 1e-10
)

qpeer.instrument(
  formula,
  Glist,
  tau,
  type = 7,
  data,
  max.distance = 1,
  checkrank = FALSE
)

qpeer.inst(
  formula,
  Glist,
  tau,
  type = 7,
  data,
  max.distance = 1,
  checkrank = FALSE
)

qpeer.insts(
  formula,
  Glist,
  tau,
  type = 7,
  data,
  max.distance = 1,
  checkrank = FALSE
)
}
\arguments{
\item{formula}{An object of class \link[stats]{formula}: a symbolic description of the model. The \code{formula} should be specified as, for example, \code{~ x1 + x2} or \code{y ~ x1 + x2},
where \code{x1} and \code{x2} are variables for which the quantiles will be computed and \code{y} is the dependent variable. If \code{y} is specified, then the quantiles of \code{x1} and \code{x2} are computed by ranking observations according to the values of \code{y} (see details).}

\item{Glist}{The adjacency matrix. For networks consisting of multiple subnets (e.g., schools), \code{Glist} must be a list of subnets, with the \code{m}-th element being an \eqn{n_m \times n_m} adjacency matrix, where \eqn{n_m} is the number of nodes in the \code{m}-th subnet.}

\item{tau}{The vector of quantile levels.}

\item{type}{An integer between 1 and 9 selecting one of the nine quantile algorithms used to compute peer quantiles (see the \link[stats]{quantile} function).}

\item{data}{An optional data frame, list, or environment (or an object that can be coerced by \link[base]{as.data.frame} to a data frame) containing the variables
in the model. If not found in \code{data}, the variables are taken from \code{environment(formula)}, typically the environment from which \code{qpeer.instruments} is called.}

\item{max.distance}{The maximum network distance of friends to consider in computing instruments.}

\item{checkrank}{A logical value indicating whether the instrument matrix should be checked for full rank. If the matrix is not of full rank, unimportant columns will be removed to obtain a full-rank matrix.}

\item{tol}{A tolerance value used in the QR factorization to identify columns that ensure a full-rank matrix (see the \link[base]{qr} function).}
}
\value{
A matrix including quantile peer variables

A list containing:
\item{qy}{Quantiles of peer variable y.}
\item{instruments}{Matrix of instruments.}
\item{index}{The indices of the two peers whose weighted average gives the quantile.}
\item{weight}{The weights of the two peers whose weighted average gives the quantile.}
}
\description{
\code{qpeer.instruments} computes quantile peer variables.
}
\details{
The sample quantile is computed as a weighted average of two peer outcomes (see Hyndman and Fan, 1996). Specifically:
\deqn{q_{\tau,i}(x_{-i}) = (1 - \omega_i)x_{i,(\pi_i)} + \omega_ix_{i,(\pi_i+1)},}
where \eqn{x_{i,(1)}, x_{i,(2)}, x_{i,(3)}, \ldots} are the order statistics of the outcome within \eqn{i}'s peers, and \eqn{q_{\tau,i}(x_{-i})} represents the sample \eqn{\tau}-quantile
of the outcome within \eqn{i}'s peer group. If \code{y} is specified, then the ranks \eqn{\pi_i} and the weights \eqn{\omega_i} for the variables in \code{X} are determined based on \code{y}.
The network matrices in \code{Glist} can be weighted or unweighted. If weighted, the sample weighted quantile is computed, where the outcome for friend \eqn{j} of \eqn{i} is weighted by \eqn{g_{ij}}, the \eqn{(i, j)} entry of the network matrix.
}
\examples{
ngr  <- 50
nvec <- rep(30, ngr)
n    <- sum(nvec)
G    <- lapply(1:ngr, function(z){
  Gz <- matrix(rbinom(sum(nvec[z]*(nvec[z] - 1)), 1, 0.3), nvec[z])
  diag(Gz) <- 0
  Gz
}) 
tau  <- seq(0, 1, 0.25)
X    <- cbind(rnorm(n), rpois(n, 2))
l    <- c(0.2, 0.1, 0.05, 0.1, 0.2)
b    <- c(2, -0.5, 1)
y    <- qpeer.sim(formula = ~X, Glist = G, tau = tau, lambda = l, beta = b)$y
Inst <- qpeer.instruments(formula = ~ X, Glist = G, tau = tau, max.distance = 2)$instruments
summary(Inst)
}
\references{
Hyndman, R. J., & Fan, Y. (1996). Sample quantiles in statistical packages. The American Statistician, 50(4), 361-365, \doi{10.1080/00031305.1996.10473566}.
}
\seealso{
\code{\link{qpeer}}, \code{\link{qpeer.sim}}, \code{\link{linpeer}}
}
