## QuantilePeer: An R package for Simulating and Estimation Quantile Peer Effect Models

**Aristide Houndetoungan**


 <!-- badges: start -->
  [![Lifecycle: experimental](https://img.shields.io/badge/Lifecycle-Experimental-orange.svg)](https://lifecycle.r-lib.org/articles/stages.html#experimental)
  [![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
  [![R-CMD-check](https://github.com/ahoundetoungan/QuantilePeer/actions/workflows/R-CMD-check.yml/badge.svg)](https://github.com/ahoundetoungan/QuantilePeer/actions/workflows/R-CMD-check.yml)

  ![R-universe](https://img.shields.io/badge/R--universe-not%20yet-lightgrey)
  [![CRAN](https://www.r-pkg.org/badges/version/QuantilePeer)](https://CRAN.R-project.org/package=QuantilePeer)
  [![CRAN Downloads](https://img.shields.io/endpoint?url=https://ahoundetoungan.github.io/cranlogs/badges/QuantilePeer.json)](https://cran.r-project.org/package=QuantilePeer)


  [![Vignette](https://img.shields.io/badge/Vignette-blue.svg)](https://docs.google.com/viewer?url=https://github.com/ahoundetoungan/QuantilePeer/raw/main/doc/introduction_to_QuantilePeer.pdf)
<!-- badges: end -->
<!-- [![CRAN status](https://www.r-pkg.org/badges/version/QuantilePeer)](https://cran.r-project.org/package=QuantilePeer) -->
<!-- [![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.XXXXXXX.svg)](DOI: 10.32614/CRAN.package) -->

### Overview

The **QuantilePeer** package implements estimation and simulation routines for quantile peer effect models introduced in [Houndetoungan (2025)](https://doi.org/10.48550/arXiv.2506.12920).
Replication code for all results in the paper is available in the [Results](https://github.com/ahoundetoungan/QuantilePeer/tree/main/Results) folder.

The package also includes functions to simulate and estimate the CES-based peer effect model developed by [Boucher et al. (2024)](https://doi.org/10.3982/ECTA21048).

### Installation

You can install the package directly from this GitHub repository using:

```r
library(remotes)
install_github("ahoundetoungan/QuantilePeer")
```


**Note for Windows users:** Make sure [**Rtools**](https://cran.r-project.org/bin/windows/Rtools/rtools44/rtools.html) is installed before installing from GitHub.


### Getting Started
See the [vignettes](https://docs.google.com/viewer?url=https://github.com/ahoundetoungan/QuantilePeer/raw/main/doc/introduction_to_QuantilePeer.pdf) for detailed examples demonstrating how to use the package.
