% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_analytics.R
\name{analyze_by_period}
\alias{analyze_by_period}
\title{Period-level summary statistics}
\usage{
analyze_by_period(
  dates,
  returns = NULL,
  values = NULL,
  period = c("monthly", "quarterly", "yearly"),
  na_rm = TRUE
)
}
\arguments{
\item{dates}{Date vector aligned to \code{returns} / \code{values}.}

\item{returns}{Numeric simple returns aligned to \code{dates} (optional).}

\item{values}{Numeric equity values aligned to \code{dates} (optional).}

\item{period}{"monthly", "quarterly", or "yearly".}

\item{na_rm}{Logical; remove NAs inside per-period aggregations.}
}
\value{
data.frame with period keys and columns: ret, start_value, end_value, n_obs.
}
\description{
Aggregates portfolio results by calendar period and computes standard statistics
for each period. Provide at least one of \code{returns} or \code{values}.
}
\examples{
\donttest{
  data(sample_prices_weekly)
  mom12 <- PortfolioTesteR::calc_momentum(sample_prices_weekly, lookback = 12)
  sel5  <- PortfolioTesteR::filter_top_n(mom12, n = 5)
  w_eq  <- PortfolioTesteR::weight_equally(sel5)
  pr    <- PortfolioTesteR::portfolio_returns(w_eq, sample_prices_weekly)
  val   <- 1e5 * cumprod(1 + pr$portfolio_return)
  out   <- analyze_by_period(
    dates   = pr$Date,
    returns = pr$portfolio_return,
    values  = val,
    period  = "monthly"
  )
  head(out)
}
}
