% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting.R
\name{plotSparseRoc}
\alias{plotSparseRoc}
\title{Plot the ROC curve using the sparse thresholdSummary data frame}
\usage{
plotSparseRoc(
  plpResult,
  typeColumn = "evaluation",
  saveLocation = NULL,
  fileName = "roc.png"
)
}
\arguments{
\item{plpResult}{A plp result object as generated using the \code{\link{runPlp}} function.}

\item{typeColumn}{The name of the column specifying the evaluation type}

\item{saveLocation}{Directory to save plot (if NULL plot is not saved)}

\item{fileName}{Name of the file to save to plot, for example
'plot.png'. See the function \code{ggsave} in the ggplot2 package for
supported file formats.}
}
\value{
A ggplot object. Use the \code{\link[ggplot2]{ggsave}} function to save to file in a different
format.
}
\description{
Plot the ROC curve using the sparse thresholdSummary data frame
}
\details{
Create a plot showing the Receiver Operator Characteristics (ROC) curve.
}
\examples{
\dontshow{if (rlang::is_installed("ggplot2")) withAutoprint(\{ # examplesIf}
\donttest{ \dontshow{ # takes too long }
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n = 1000, seed = 42)
saveLoc <- file.path(tempdir(), "plotSparseRoc")
results <- runPlp(plpData, outcomeId = 3, saveDirectory = saveLoc)
plotSparseRoc(results)
# clean up
unlink(saveLoc, recursive = TRUE)
}
\dontshow{\}) # examplesIf}
}
