% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/plates_class.R
\name{build_injec_seq}
\alias{build_injec_seq}
\alias{build_injec_seq,PlateObj-method}
\alias{build_injec_seq,MultiPlate-method}
\title{Create Injection Sequence}
\usage{
build_injec_seq(
  plate,
  method,
  rep_DB = 2,
  rep_ISblank = 1,
  rep_suitability = 1,
  rep_blank = 2,
  repeat_std = 1,
  repeat_qc = 1,
  repeat_analyte = 1,
  repeat_dqc = 1,
  n_explore = 0,
  blank_after_top_conc = TRUE,
  blank_at_end = TRUE,
  blank_every_n = NULL,
  injec_vol,
  descr = "",
  prefix = Sys.Date(),
  suffix = "1",
  tray = 1,
  conc_df = NULL,
  grouped = TRUE
)

\S4method{build_injec_seq}{PlateObj}(
  plate,
  method,
  rep_DB = 2,
  rep_ISblank = 1,
  rep_suitability = 1,
  rep_blank = 2,
  repeat_std = 1,
  repeat_qc = 2,
  repeat_analyte = 1,
  repeat_dqc = 1,
  n_explore = 0,
  blank_after_top_conc = TRUE,
  blank_at_end = TRUE,
  blank_every_n = NULL,
  injec_vol,
  descr = "",
  prefix = Sys.Date(),
  suffix = "1",
  tray = 1,
  conc_df = NULL,
  grouped = TRUE
)

\S4method{build_injec_seq}{MultiPlate}(
  plate,
  method,
  rep_DB = 2,
  rep_ISblank = 1,
  rep_suitability = 1,
  rep_blank = 2,
  repeat_std = 1,
  repeat_qc = 1,
  repeat_analyte = 1,
  repeat_dqc = 1,
  n_explore = 0,
  blank_after_top_conc = TRUE,
  blank_at_end = TRUE,
  blank_every_n = NULL,
  injec_vol,
  descr = "",
  prefix = Sys.Date(),
  suffix = "1",
  tray = 1,
  conc_df = NULL,
  grouped = TRUE
)
}
\arguments{
\item{plate}{PlateObj object}

\item{method}{choose method from database}

\item{rep_suitability}{Number of re-injections for suitability vial.}

\item{repeat_std}{number of re-injections for calibration standards. Default is 1.}

\item{repeat_qc}{number of re-injections for QC wells. Default is 1}

\item{repeat_analyte}{number of re-injections for unknown samples. Default is 1}

\item{n_explore}{A number of exploratory samples to be injected at the top of the entire sequence. Default is 0}

\item{blank_after_top_conc}{If TRUE, adding blank after high concentrations of standards and QCS.}

\item{blank_at_end}{If True, adding blank at the end of queue.}

\item{blank_every_n}{If no QCs, frequency of injecting blanks between analytes.}

\item{injec_vol}{volume of injection in micro liters.}

\item{descr}{Run description.}

\item{prefix}{string at the beginning of the filename. Default is today's date.}

\item{suffix}{string to be added to the end of the filename. Default is "1".}

\item{tray}{Location in sample manager.}

\item{conc_df}{data.frame matching compound name to a scaling factor. Maximum 20 compounds allowed.}
}
\value{
InjecListObj object

InjecListObj object

InjecListObj object
}
\description{
Create Injection Sequence

Create Injection Sequence from PlateObj (Single Plate)

Create Injection Sequence from MultiPlate (Multiple Plates)
}
\details{
n_explore controls if exploratory samples are to be injected. A random sample from each CS and QC group will be sampled along with 1 blank sample.
}
\keyword{internal}
