% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-100-DMUs.R
\docType{data}
\name{data}
\alias{data}
\title{Simulated efficiency dataset (100 DMUs)}
\format{
A \code{data.frame} with 100 rows and 3 columns:
\describe{
\item{x1}{Input of the DMU (e.g., resource use, cost or effort).}
\item{y}{Observed output, potentially affected by technical inefficiency.}
\item{yD}{Deterministic (theoretical) output on the efficient frontier.}
}
}
\source{
Simulated data generated by the authors for illustrative purposes.
}
\usage{
data(data)
}
\description{
Dataset with 100 simulated decision-making units (DMUs) used to illustrate
the basic workflow of \pkg{PEAXAI} in a simple single-input/single-output
setting.
}
\details{
Each DMU uses one input \code{x1} to produce an output \code{y}. The variable
\code{yD} represents the theoretical output on the deterministic frontier,
that is, the output level that would be observed in the absence of
technical inefficiency.

The dataset is purely simulated and is intended for examples and vignettes.
It contains 100 DMUs with heterogeneous input levels and corresponding
output levels. The observed output \code{y} can be interpreted as
\code{y <= yD}, where the gap between \code{yD} and \code{y} reflects
technical inefficiency (plus possible noise, depending on how the data
were generated).
}
\examples{
data(data)
str(data)
summary(data)

if (requireNamespace("ggplot2", quietly = TRUE)) {
  ggplot2::ggplot(data, ggplot2::aes(x = x1)) +
    ggplot2::geom_point(ggplot2::aes(y = y), alpha = 0.6) +
    ggplot2::geom_line(ggplot2::aes(y = yD), color = "red") +
    ggplot2::labs(
      x = "Input x1",
      y = "Output",
      title = "Simulated DMUs and theoretical frontier"
    ) +
    ggplot2::theme_minimal()
}

}
\keyword{datasets}
