% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_structure.R
\name{show_structure}
\alias{show_structure}
\title{Print a description of the variables in a dataset}
\usage{
show_structure(data, display_redacted = FALSE, clipboard = TRUE)
}
\arguments{
\item{data}{\itemize{
\item The name of an R dataset
}}

\item{display_redacted}{\itemize{
\item Logical. Option to have empty table cells for character
and date formats (the default) or to display "< redacted strings|dates >" for
charater strings and dates, respectively.
}}

\item{clipboard}{\itemize{
\item Copy results to clipboard (TRUE by default)
}}
}
\value{
A formatted markdown table (via knitr::kable) displaying the
structure of the input dataset. The table contains three columns:
\item{variable}{Column names from the input data}
\item{type}{Data type of each column (e.g., "numeric", "factor", "Date")}
\item{levels}{For factors: comma-separated factor levels;
for numeric/integer: value range; for other types: NA}
}
\description{
This function prints the name of a dataset and then details on its variables.
Run this, then check the output to make sure it does not show any sensitive
information.  If it does not, paste it into your favorite AI's chat box to
help it understand the problem you are solving.
}
\examples{
show_structure(mtcars)
}
