% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dependence.R
\name{NNS.dep}
\alias{NNS.dep}
\title{NNS Dependence}
\usage{
NNS.dep(x, y = NULL, asym = FALSE, p.value = FALSE, print.map = FALSE)
}
\arguments{
\item{x}{a numeric vector, matrix or data frame.}

\item{y}{\code{NULL} (default) or a numeric vector with compatible dimensions to \code{x}.}

\item{asym}{logical; \code{FALSE} (default) Allows for asymmetrical dependencies.}

\item{p.value}{logical; \code{FALSE} (default) Generates 100 independent random permutations to test results against and plots 95 percent confidence intervals along with all results.}

\item{print.map}{logical; \code{FALSE} (default) Plots quadrant means, or p-value replicates.}
}
\value{
Returns the bi-variate \code{"Correlation"} and \code{"Dependence"} or correlation / dependence matrix for matrix input.
}
\description{
Returns the dependence and nonlinear correlation between two variables based on higher order partial moment matrices measured by frequency or area.
}
\note{
For asymmetrical \code{(asym = TRUE)} matrices, directional dependence is returned as ([column variable] ---> [row variable]).
}
\examples{
\dontrun{
set.seed(123)
x <- rnorm(100) ; y <- rnorm(100)
NNS.dep(x, y)

## Correlation / Dependence Matrix
x <- rnorm(100) ; y <- rnorm(100) ; z <- rnorm(100)
B <- cbind(x, y, z)
NNS.dep(B)
}
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments" (ISBN: 1490523995)
}
\author{
Fred Viole, OVVO Financial Systems
}
