% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow.R
\name{shadow_bind_data}
\alias{shadow_bind_data}
\title{Bind the shadow matrix to the data}
\usage{
shadow_bind_data(
  data,
  shadow = NULL,
  naniar_shadow = FALSE,
  id_cols = union(get_id_cols_abcd(), get_id_cols_hbcd()),
  suffix = "_shadow"
)
}
\arguments{
\item{data}{tibble. The data.}

\item{shadow}{tibble. The shadow matrix. If \code{naniar_shadow} is \code{TRUE},
this argument is ignored.}

\item{naniar_shadow}{logical. Whether to use \code{naniar::as_shadow()} to
create the shadow matrix from data instead of providing it as an
argument.}

\item{id_cols}{character. The columns to join by (the identifier column(s))
in the data and shadow matrices (Default: identifier columns used in ABCD and
HBCD).
In \code{naniar_shadow = TRUE}, these columns are not included in the
shadow matrix.}

\item{suffix}{character. The suffix to add to the shadow columns.
Default is \code{"_shadow"}. For example, if the column name is
\code{"var1"} and the suffix is \code{"_shadow"}, the
resulted column name will be \code{"var1_shadow"}.

If \code{naniar_shadow = TRUE}, the suffix is \verb{_NA}, as this suffix will
have the most compatibility with other functions in the \code{naniar} package.}
}
\value{
a dataframe of the data matrix with shadow columns. It will be
2x the size of the original data matrix.
}
\description{
This function binds the shadow matrix to the data.
}
\details{
\subsection{Data requirements}{

If \code{naniar_shadow = FASLE} and \code{shadow} is provided, the two dataframes
must have the same columns, order of the columns does not matter, but
ID columns must be the same in both dataframes. If there are extra
rows in the shadow matrix, they will be ignored.
}

\subsection{ABCD and HBCD data}{

NBDC releases HBCD data with shadow matrices, which can be used for
the \code{shadow} argument. To work with ABCD data, the option for
now is to use \code{naniar_shadow = TRUE}, which will create a shadow matrix
from the data using \code{naniar::as_shadow()}.
}
}
\examples{
\dontshow{if (requireNamespace("NBDCtoolsData", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
shadow <- tibble::tibble(
  participant_id = c("1", "2", "3"),
  session_id = c("1", "2", "3"),
  var1 = c("Unknown", NA, NA),
  var2 = c("Wish not to answer", NA, NA)
)
data <- tibble::tibble(
  participant_id = c("1", "2", "3"),
  session_id = c("1", "2", "3"),
  var1 = c(NA, NA, 1),
  var2 = c(NA, 2, NA)
)
shadow_bind_data(data, shadow)
if (requireNamespace("naniar", quietly = TRUE)) {
  shadow_bind_data(data, naniar_shadow = TRUE)
}
\dontshow{\}) # examplesIf}
}
