% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ILDS.r
\name{ILDSR2}
\alias{ILDSR2}
\title{Compute R2 for Interlandmark Distances}
\usage{
ILDSR2(
  x,
  groups,
  R2tol = 0.9,
  autocluster = TRUE,
  gap = TRUE,
  bg.rounds = 999,
  wg.rounds = 999,
  which = 1:2,
  reference = NULL,
  target = NULL,
  mc.cores = 1,
  plot = FALSE,
  silent = FALSE,
  ...
)
}
\arguments{
\item{x}{array containing landmarks}

\item{groups}{vector containing group assignments or a numeric covariate. For groups with more than two levels, a pair of needs to be specified using \code{which}}

\item{R2tol}{numeric: upper percentile for ILD R2 in relation to factor or in case \code{autocluster=TRUE}, the minimum quantile allowed.}

\item{autocluster}{logical: if TRUE, the function is trying to find a cluster with the highest R2-values. In this case \code{R2tol} is used as the quantile the cluster is allowed to occupy.}

\item{gap}{logical: if TRUE, the largest gap in the R2 distribution is sought. If FALSE, a clustering procedure is used.}

\item{bg.rounds}{numeric: number of permutation rounds to assess between group differences}

\item{wg.rounds}{numeric: number of rounds to assess noise within groups by bootstrapping.}

\item{which}{integer (optional): in case the factor levels are > 2 this determins which factorlevels to use}

\item{reference}{matrix containing start config landmarks. If NULL, it will be computed as mean for group 1.}

\item{target}{matrix containing target config landmarks. If NULL, it will be computed as mean for group 2.}

\item{mc.cores}{integer: number of cores to use for permutation tests.}

\item{plot}{logical: if TRUE show graphical output of steps involved}

\item{silent}{logical: suppress console output}

\item{...}{additional parameters for internal use only.}
}
\value{
A list containing:
\item{relevantILDs}{containing landmark information with the highest R2-values}
\item{allR2}{vector with ILD specific R2-values, sorted decreasingly}
\item{reftarILDS}{matrix with columns containing ILDs for reference and target shapes}
\item{sampleILD}{matrix containing ILDs of entire sample}
\item{R2tol}{R2-threshold used}
\item{reference}{reference used}
\item{target}{target used}
\item{bg.test}{result from between-group testing}
\item{confR2}{confidence for relevant ILDs from bootstrapping}
\item{x}{Procrustes superimposed raw data (without scaling)}
}
\description{
Compute R2 for Interlandmark Distances explaining between group differences
}
\examples{
require(Morpho)
data(boneData)
proc <- procSym(boneLM)
groups <- name2factor(boneLM,which=3)
ilds <- ILDSR2(proc$rotated,groups,plot=TRUE,wg.rounds=99,mc.cores=1)
if (interactive())
visualize(ilds)
## use covariate
\dontrun{
ildsLM <- ILDSR2(proc$rotated,groups=proc$size,plot=TRUE,wg.rounds=99,mc.cores=1)
if (interactive())
visualize(ildsLM)
}

## 2D Case with size as predictor
require(shapes)
require(Morpho)
gor.dat <- bindArr(gorf.dat,gorm.dat,along=3)
procg <- procSym(gor.dat)
ildsg <- ILDSR2(procg$rotated,procg$size,plot=FALSE,bg.rounds=999,wg.rounds=99,
                mc.cores=1,autocluster=TRUE,R2tol=.8)
}
