% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl-handling.R
\name{combine}
\alias{combine}
\title{Combine several objects}
\usage{
combine(...)
}
\arguments{
\item{...}{a list of Out(Coe), Opn(Coe), Ldk objects (but of the same class)}
}
\value{
a Momocs object of same class
}
\description{
Combine \code{Coo} objects after a slicing, either manual or using \link{slice} or \link{chop}. Note that on Coo object,
it combines row-wise (ie, merges shapes as a \code{c} would do) ; but on Coe it combines column-wise
(merges coefficients). In the latter case, Coe must have the same number of shapes (not
necessarily the same number of coefficients).
Also the \code{$fac} of the first Coe is retrieved.
A separate version may come at some point.
}
\note{
Note that the order of shapes or their coefficients
is not checked, so anything with the same number of rows will be merged.
}
\examples{
w <- filter(bot, type=="whisky")
b <- filter(bot, type=="beer")
combine(w, b)
# or, if you have many levels
bot_s <- chop(bot, ~type)
bot_s$whisky
# note that you can apply something (single function or a more
# complex pipe) then combine everyone, since combine also works on lists
# eg:
# bot_s2 <- efourier(bot_s, 10) # equivalent to lapply(bot_s, efourier, 10)
# bot_sf <- combine(bot_s2)

# pipe style
efourier(bot_s, 10) \%>\% combine()
}
\seealso{
Other handling functions: 
\code{\link{arrange}()},
\code{\link{at_least}()},
\code{\link{chop}()},
\code{\link{dissolve}()},
\code{\link{fac_dispatcher}()},
\code{\link{filter}()},
\code{\link{mutate}()},
\code{\link{rename}()},
\code{\link{rescale}()},
\code{\link{rm_harm}()},
\code{\link{rm_missing}()},
\code{\link{rm_uncomplete}()},
\code{\link{rw_fac}()},
\code{\link{sample_frac}()},
\code{\link{sample_n}()},
\code{\link{select}()},
\code{\link{slice}()},
\code{\link{subsetize}()}
}
\concept{handling functions}
