% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/candidate_trt_set.R
\name{candidate_trt_set}
\alias{candidate_trt_set}
\title{Forms the labelled candidate set of treatments}
\usage{
candidate_trt_set(Levels, K, Hypercube = TRUE)
}
\arguments{
\item{Levels}{Levels of each factor.}

\item{K}{Number of factors.}

\item{Hypercube}{Indicates if the experimental region is a hypercube ('TRUE') or spherical ('FALSE').}
}
\value{
Matrix of candidate set of treatments, with treatment labels contained in the first column.
}
\description{
This function forms the candidate set of treatments from the factors' levels,
adds labels, with optional spherical transformation of the coordinates.
}
\examples{

# Candidate treatment set for five 3-level factors

K<-5; Levels <- rep(list(1:3),K);
candidate_trt_set(Levels, K) 
}
