% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_IVDML.R
\name{print.IVDML}
\alias{print.IVDML}
\title{Print IVDML}
\usage{
\method{print}{IVDML}(x, ...)
}
\arguments{
\item{x}{Fitted object of class \code{IVDML}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
No return value, called for side effects
}
\description{
Print information for an IVDML object.
}
\examples{
set.seed(1)
Z <- rnorm(100)
X <- Z + rnorm(100)
H <- rnorm(100)
D <- Z^2 + sin(X) + H + rnorm(100)
A <- X
Y <- tanh(A) * D + cos(X) - H + rnorm(100)
fit <- fit_IVDML(Y = Y, D = D, Z = Z, X = X, A = A, ml_method = "gam")
print(fit)

}
