% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_interval_probs.R
\name{construct_interval_probs}
\alias{construct_interval_probs}
\title{construct_interval_probs.R}
\usage{
construct_interval_probs(
  allTimes,
  dmats,
  nullBeta,
  p,
  nKnots,
  infVal = 999,
  zeroVal = 0
)
}
\arguments{
\item{allTimes}{n*s matrix where n is number of subjects and s is all visit times for that subjects.}

\item{dmats}{Output from make_IC_dmats, a list holding left_dmat and right_dmat.}

\item{nullBeta}{Vector of coefficients under the null model.}

\item{p}{Number of covariates in the null model.}

\item{nKnots}{Number of knots in the spline.}

\item{infVal}{The numeric value representing time 0 (left-censored observation).}

\item{zeroVal}{The numeric value representing time infinity (right-censored observation).}
}
\value{
n*(s+1) matrix where element (i,j) holds the probability that subject i will fail in interval j.
}
\description{
Construct the probabilities of falling into each time interval for bootstrapping of interval-censored data.
}
\examples{
set.seed(2)
xMat <- matrix(data=rnorm(200), nrow=100)
bhFunInv <- function(x) {x}
obsTimes <- 1:5
etaVec <- rep(0, 100)
outcomeDat <- gen_IC_data(bhFunInv = bhFunInv, obsTimes = obsTimes, windowHalf = 0.1,
probMiss = 0.1, etaVec = etaVec)
lt <- outcomeDat$leftTimes
rt <- outcomeDat$rightTimes
tpos_ind <- as.numeric(lt > 0)
obs_ind <- as.numeric(rt != Inf)
dmats <- make_IC_dmat(xMat, lt, rt, obs_ind, tpos_ind)
nullFit <- ICSKAT_fit_null(init_beta = rep(0, 5), left_dmat = dmats$left_dmat,
right_dmat=dmats$right_dmat, obs_ind = obs_ind, tpos_ind = tpos_ind,
lt = lt, rt = rt)
intervalProbOutput <- construct_interval_probs(allTimes = outcomeDat$allVisits,
dmats = dmats, nullBeta = nullFit$beta_fit, p = ncol(xMat), nKnots=1)

}
