% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_VisualizeMapPoints.R
\name{VisualizeMapPoints}
\alias{VisualizeMapPoints}
\alias{VisualiseMapPoints}
\title{Shiny App for visualizing Mapped Point Information.}
\usage{
VisualizeMapPoints(
  results.dir = NULL,
  file.pattern = "^(map|subass).*\\\\.(txt|csv)$",
  sites = NULL,
  sites.subid.column = 1,
  bg = NULL,
  output.dir = NULL
)

VisualiseMapPoints(
  results.dir = NULL,
  file.pattern = "^(map|subass).*\\\\.(txt|csv)$",
  sites = NULL,
  sites.subid.column = 1,
  bg = NULL,
  output.dir = NULL
)
}
\arguments{
\item{results.dir}{Optional string, path to a directory containing e.g. MapOutput or Subass files that should be loaded on app initialization.}

\item{file.pattern}{Optional string, filename pattern to select files in \code{results.dir} that should be loaded on app initialization. See \code{\link{list.files}}.}

\item{sites}{Optional string, path to GIS file for outlet points that should be loaded on app initialization. Typically a GeoPackage (.gpkg) or Shapefile (.shp).}

\item{sites.subid.column}{Optional integer, column index in the \code{map} 'data' \code{\link{slot}} holding SUBIDs (sub-catchment IDs) that should be used on app initialization.}

\item{bg}{Optional string, path to GIS file with polygon geometry to plot in the background. Typically an imported sub-basin vector polygon file.}

\item{output.dir}{Optional string, path to a default output directory to save captured map images.}
}
\value{
\code{VisualizeMapPoints} returns a Shiny application object.
}
\description{
Interactive maps and plots for visualizing mapped point information, e.g. HYPE MapOutput files or model performances at observation sites.
}
\details{
\code{VisualizeMapPoints} is a Shiny app that provides interactive maps, plots, and tables for visualizing mapped point information. The interactive Leaflet map is generated using \code{\link{PlotMapPoints}}.
The app can be launched with or without the input arguments. All necessary input buttons and menus are provided within the app interface. For convenience, however, the input arguments can be provided in order to quickly launch the
app with desired settings.
}
\examples{
\dontrun{
if (interactive()) {
  VisualizeMapPoints(
    results.dir = system.file("demo_model", "results", package = "HYPEtools"),
    sites = system.file("demo_model", "gis", "Nytorp_centroids.gpkg", package = "HYPEtools"),
    sites.subid.column = 25,
    bg = system.file("demo_model", "gis", "Nytorp_map.gpkg", package = "HYPEtools")
  )
}
}

}
\seealso{
\code{\link{ReadMapOutput}}; \code{\link{PlotMapPoints}}
}
