% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_ScaleFloodData.R
\name{ScaleFloodData}
\alias{ScaleFloodData}
\title{Scale 'FloodData.txt' files to different model time steps}
\usage{
ScaleFloodData(
  x = NULL,
  timestep.ratio = 1/24,
  digits = 3,
  verbose = TRUE,
  print.par = FALSE
)
}
\arguments{
\item{x}{Data frame containing HYPE FloodData contents. Typically imported with \code{\link[=ReadFloodData]{ReadFloodData()}}.}

\item{timestep.ratio}{Numeric, time step scaling factor. Defaults to (1/24) to scale from daily to hourly time steps. To scale from hourly to daily time steps use 24.}

\item{digits}{Integer, number of significant digits in scaled parameter values to export. See \code{\link[=signif]{signif()}}.}

\item{verbose}{Logical, if \code{TRUE}, then information will be printed.}

\item{print.par}{Logical, print known time-scale dependent recession coefficients instead of scaling a FloodData data frame.}
}
\value{
A \code{\link[=data.frame]{data.frame()}} object as supplied in \code{x}, with re-scaled recession coefficients, or nothing if \code{print.par = TRUE}.
}
\description{
\code{ScaleFloodData} scales the time step-dependent recession coefficients in an imported
\href{http://hype.smhi.net//wiki/doku.php?id=start:hype_file_reference:flooddata.txt}{HYPE 'FloodData.txt'} file to a
new target time step. See HYPE wiki tutorial on \href{http://hype.smhi.net//wiki/doku.php?id=start:hype_tutorials:subdaily_timesteps}{sub-daily time steps}.
}
\details{
\code{ScaleFloodData} applies a user-specified scaling factor \code{timestep.ratio} to the time step-dependent recession coefficients
in a HYPE FloodData data frame. ' Recession coefficients are matched against an inbuilt set of column names. To see these names, call \code{ScaleFloodData(print.par = TRUE)}.
\emph{\href{https://github.com/rcapell/HYPEtools/issues}{Please notify us} if you find any missing coefficients.}

Timestep-dependent recession coefficients are scaled using the relationship described in:
Nalbantis, Ioannis (1995). “Use of multiple-time-step information in rainfall-runoff modelling”, Journal of Hydrology 165, 1-4, pp. 135–159.

\code{new_coefficient_value = 1 - (1 - old_coefficient_value)^time_step_ratio}

Use the \code{\link{ScalePar}} and \code{\link{ScaleAquiferData}} functions to scale the time-dependent parameters and recession coefficients in par.txt and AquiferData.txt files, respectively.
Note that \code{ScalePar} does not scale the values for the "gratk", "ilratk", "olratk", or "wetrate" rating curve recession coefficients in par.txt because they are not limited to the range 0-1.
Likewise, HYPEtools does not provide any scaling function for the "RATE" columns in DamData.txt and LakeData.txt because these values are not limited to the range 0-1.
We recommend looking at the results from the lakes/wetlands and recalibrating these parameters and their related power coefficients as needed.
}
\examples{
# Import daily HYPE FloodData file
fd <- ReadFloodData(filename = system.file("demo_model",
"FloodData_Example.txt", package = "HYPEtools"))
# Scale to hourly time steps
ScaleFloodData(x = fd)
# Print all time scale-dependent coefficients known to the function
ScaleFloodData(print.par = TRUE)

}
\seealso{
\code{\link{ScaleAquiferData}}
\code{\link{ScalePar}}
}
