% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functioncollection_import.R
\name{ReadClassData}
\alias{ReadClassData}
\title{Read a 'ClassData.txt' File}
\usage{
ReadClassData(
  filename = "ClassData.txt",
  encoding = c("unknown", "UTF-8", "Latin-1"),
  verbose = TRUE
)
}
\arguments{
\item{filename}{Path to and file name of the ClassData file to import. Windows users: Note that
Paths are separated by '/', not '\\'.}

\item{encoding}{Character string, encoding of non-ascii characters in imported text file. Particularly relevant when
importing files created under Windows (default encoding "Latin-1") in Linux (default encoding "UTF-8") and vice versa. See
also argument description in \code{\link[data.table]{fread}}.}

\item{verbose}{Print information on number of data columns in imported file.}
}
\value{
\code{ReadClassData} returns a data frame with added attribute 'comment'.
}
\description{
This is a convenience wrapper function to import a ClassData file as data frame into R. ClassData files contain definitions
of SLC (\bold{S}oil and \bold{L}and use \bold{C}rop) classes in five to 15 predefined columns, see
\href{http://hype.smhi.net//wiki/doku.php?id=start:hype_file_reference:classdata.txt}{ClassData.txt documentation}.
}
\details{
\code{ReadClassData} is a convenience wrapper function of \code{\link[data.table]{fread}}, with treatment of leading
comment rows. Column names are created on import, optional comment rows are imported as strings in \code{attribute} 'comment'.
Optional inline comments (additional non-numeric columns) are automatically identified and imported along with data columns.
}
\examples{
te <- ReadClassData(filename = system.file("demo_model", "ClassData.txt", package = "HYPEtools"))
te

}
\seealso{
\code{\link{ReadGeoClass}}
}
