#'@title Function used to perform parallel computing for pseudo-observations of generalized Ornstein-Uhlenbeck
#'
#'@description This function simulates values of the Cramer-von Mises and Kolmogorov-Smirnov statistics for testing goodness-of-fit of GOU.
#'
#'@param n    number of simulated points.
#'
#'@return \item{out}{List of gof statistics for GOU: ks (Kolmogorov-Smirnov) and cvm ( Cramer-von Mises)}
#'
#'@keywords internal
#'
#'@export
#'
#'

funGoF <- function(n)
{
  eps = rnorm(n)
  m = mean(eps)
  s = sqrt(var(eps))
  u = sort(pnorm((eps-m)/s))
  sn = sqrt(n)
  tt0=c(1:n)/n
  tt = tt0-0.5/n
  cvm = 1/(12*n)+ sum((u-tt)^2)
  ks=sn*max(abs(u-tt0),abs(u-tt0+1/n))
  out=list(cvm=cvm,ks=ks)
  out
}
