% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_export.R
\name{recoinfo}
\alias{recoinfo}
\title{Informations on the reconciliation process}
\usage{
recoinfo(x, verbose = TRUE)
}
\arguments{
\item{x}{An output from any reconciliation function implemented by \pkg{FoReco}.}

\item{verbose}{If \code{TRUE} (\emph{defaults}), reconciliation information are printed.}
}
\value{
A list containing the following reconciliation process informations:
\item{rfun}{the reconciliation function.}
\item{cs_n}{the cross-sectional number of variables.}
\item{te_set}{the set of temporal aggregation orders.}
\item{forecast_horizon}{the forecast horizon
(in temporal and cross-temporal frameworks, for the most temporally aggregated series).}
\item{framework}{the reconciliation framework (cross-sectional, temporal or cross-temporal).}
\item{info}{non-negative reconciled forecast convergence information.}
\item{lcc}{list of level conditional reconciled forecasts (+ BU) for
\link{cslcc}, \link{telcc} and \link{ctlcc}.}
\item{nn}{if \code{TRUE}, all the forecasts are not negative.}
\item{comb}{the covariance approximation.}
}
\description{
This function extracts reconciliation information from the output of any reconciled
function implemented by \pkg{FoReco}.
}
\seealso{
Utilities: 
\code{\link{FoReco2matrix}()},
\code{\link{aggts}()},
\code{\link{balance_hierarchy}()},
\code{\link{commat}()},
\code{\link{csprojmat}()},
\code{\link{cstools}()},
\code{\link{ctprojmat}()},
\code{\link{cttools}()},
\code{\link{df2aggmat}()},
\code{\link{lcmat}()},
\code{\link{res2matrix}()},
\code{\link{set_bounds}()},
\code{\link{shrink_estim}()},
\code{\link{shrink_oasd}()},
\code{\link{teprojmat}()},
\code{\link{tetools}()},
\code{\link{unbalance_hierarchy}()}
}
\concept{Utilities}
