% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_export.R
\name{balance_hierarchy}
\alias{balance_hierarchy}
\title{Aggregation matrix of a (possibly) unbalanced hierarchy in balanced form}
\usage{
balance_hierarchy(agg_mat, nodes = "auto", sparse = TRUE)
}
\arguments{
\item{agg_mat}{A (\eqn{n_a \times n_b}) numeric matrix representing the cross-sectional
aggregation matrix. It maps the \eqn{n_b} bottom-level (free)
variables into the \eqn{n_a} upper (constrained) variables.}

\item{nodes}{A (\eqn{L \times 1}) numeric vector indicating the number of variables
in each of the upper \eqn{L} levels of the hierarchy. The \emph{default}
value is the string "\code{auto}" which calculates the number of variables in each level.}

\item{sparse}{Option to return sparse matrices (\emph{default} is \code{TRUE}).}
}
\value{
A list containing four elements:
\item{bam}{The balanced aggregation matrix.}
\item{agg_mat}{The input matrix.}
\item{nodes}{A (\eqn{L \times 1}) numeric vector indicating the number of variables
in each of the \eqn{L} upper levels of the balanced hierarchy.}
\item{id}{The identification number of each variable in the balanced hierarchy.
It may contains duplicated values.}
}
\description{
A hierarchy with \eqn{L} upper levels is said to be balanced if each variable at level
\eqn{l} has at least one child at level \eqn{l+1}. When this doesn't hold, the hierarchy
is unbalanced. This function transforms an aggregation matrix of an unbalanced hierarchy
into an aggregation matrix of a balanced one. This function is used to reconcile forecasts
with \link{cslcc}, which operates exclusively with balanced hierarchies.
}
\examples{
#    Unbalanced     ->      Balanced
#        T                     T
#    |-------|             |-------|
#    A       |             A       B
#  |---|     |           |---|     |
# AA   AB    B          AA   AB    BA
A <- matrix(c(1, 1, 1,
              1, 1, 0), 2, byrow = TRUE)
obj <- balance_hierarchy(agg_mat = A, nodes = c(1, 1))
obj$bam
}
\seealso{
Utilities: 
\code{\link{FoReco2matrix}()},
\code{\link{aggts}()},
\code{\link{commat}()},
\code{\link{csprojmat}()},
\code{\link{cstools}()},
\code{\link{ctprojmat}()},
\code{\link{cttools}()},
\code{\link{df2aggmat}()},
\code{\link{lcmat}()},
\code{\link{recoinfo}()},
\code{\link{res2matrix}()},
\code{\link{set_bounds}()},
\code{\link{shrink_estim}()},
\code{\link{shrink_oasd}()},
\code{\link{teprojmat}()},
\code{\link{tetools}()},
\code{\link{unbalance_hierarchy}()}
}
\concept{Utilities}
