% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingness.R
\name{missingness}
\alias{missingness}
\title{missingness test}
\usage{
missingness(
  TS,
  title = FALSE,
  plot = TRUE,
  increasing = TRUE,
  cols = c("white", "blue"),
  omar = c(2, 2, 2, 2),
  mar = c(3, 5, 3, 2)
)
}
\arguments{
\item{TS}{A data frame of streamflow time series loaded with \code{\link{read.flows}}.}

\item{title}{optional plot title. Default is FALSE indicating no plot title is wanted. 
Set to TRUE to use the the default plot title, which will 
look for 'plot title' attribute of the data.frame set by 
\code{\link{set.plot.titles}}. All values other values 
will be used as a custom plot title.}

\item{plot}{Logical, default is TRUE. If FALSE, does not produce a plot.}

\item{increasing}{Logical, default is TRUE. If FALSE, years are ordered from top to bottom.}

\item{cols}{Plot colors, default is white and blue. White always corresponds to NA. Only observed color can be changed.}

\item{omar}{Vector of length 4, outer margins for the plot.}

\item{mar}{Vector of length 4, margins for the plot.}
}
\value{
A list containing:
  \itemize{
    \item \code{years_total}: Number of years from start to ending year.
    \item \code{years_with_obs}: Number of years with observations.
    \item \code{years_no_missing_obs}: Number of years with no missing days.
    \item \code{complete_years}: Individual years with no missing data.
    \item \code{partial_years}: Individual years with some observations.
    \item \code{longest_common_period_years}: Number of sequential years with complete data.
    \item \code{lcperiod_st}: Starting year of the sequence of years with complete data.
    \item \code{lcperiod_nd}: Ending year of the sequence of years with complete data.
    \item \code{table}: A dataframe with years, and counts and fractions of missing data.
    \item \code{missingness plot}: A plot showing the missingness data (if \code{plot = TRUE}).
  }
}
\description{
Determine the annual amount of missing data and generate an
optional missingness plot.
}
\details{
Determine the Annual Amount of Missing Data and Generate a Missingness Plot
}
\examples{
robin_path <- system.file("extdata", "ROBIN_example.csv", package = "FlowScreen")

TS <- read.flows(robin_path)
res <- missingness(TS, cols = c("white", "red"), increasing = FALSE)

}
\author{
Paul Whitfield
}
