% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop.years.R
\name{drop.years}
\alias{drop.years}
\title{Drop hydrologic years}
\usage{
drop.years(TS, NAthresh = 0.8)
}
\arguments{
\item{TS}{data.frame of streamflow time series loaded with \code{\link{read.flows}}.}

\item{NAthresh}{Numeric value indicating the threshold for missing data points
in any one year.  Default is 0.80, indicating that years with more than 80 percent missing data
will be omitted from the metric calculations. This value should always be set to 
greater than 0.1, as years with fewer observations than approximately 1 month will
cause errors.}
}
\value{
Returns TS data.frame with hydrologic years with % of missing data 
  above the user-defined threshold dropped.
}
\description{
Removesthose hydrologic years where the fraction of missing data is above the 
defined threshold.
}
\examples{
data(caniapiscau)
cania.ts <- create.ts(caniapiscau, hyrstart = 4)
cania.ts <- drop.years(cania.ts, NAthresh = 0.75)
}
\author{
Jennifer Dierauer
}
