% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FMAT.R
\name{special_case}
\alias{special_case}
\title{Specify models that require special treatment to ensure accuracy.}
\usage{
special_case(
  uncased = "uncased|albert|electra|muhtasham",
  u2581 = "albert|xlm-roberta|xlnet",
  u2581.excl = "chinese",
  u0120 = "roberta|bart|deberta|bertweet-large|ModernBERT",
  u0120.excl = "chinese|xlm-|kornosk/"
)
}
\arguments{
\item{uncased}{Regular expression pattern (matching model names) for uncased models.}

\item{u2581, u0120}{Regular expression pattern (matching model names) for models that require a special prefix character when performing whole-word fill-mask pipeline.

\strong{WARNING}: The developer is unable to check all models, so users need to check the models they use and modify these parameters if necessary.
\itemize{
\item \code{u2581}: add prefix \verb{\\u2581} (white space) for all mask words
\item \code{u0120}: add prefix \verb{\\u0120} (white space) for only non-starting mask words
}}

\item{u2581.excl, u0120.excl}{Exclusions to negate \code{u2581} and \code{u0120} matching results.}
}
\value{
A list of regular expression patterns.
}
\description{
Specify models that require special treatment to ensure accuracy.
}
\examples{
special_case()

}
\seealso{
\code{\link[=FMAT_run]{FMAT_run()}}
}
