% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epi_functions.R
\name{epi_model}
\alias{epi_model}
\title{Unified Epidemiological Modeling}
\usage{
epi_model(
  data,
  formula = NULL,
  type = c("power", "survival", "snp", "logistic", "kmeans", "rf", "svmRadial"),
  ...
)
}
\arguments{
\item{data}{Input data frame with relevant columns (e.g., outcome, genotypes).}

\item{formula}{Model formula (optional, for survival/logistic/rf/svmRadial, e.g., "outcome ~ x").}

\item{type}{Model type: "power", "survival", "snp", "logistic", "kmeans", "rf", "svmRadial".}

\item{...}{Additional parameters (e.g., n, effect_size for power; k for kmeans).}
}
\value{
A data frame or list with model results.
}
\description{
Performs clinical trial power calculation, survival analysis, SNP association, logistic regression, k-means clustering, Random Forest, or SVM.
}
